<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Digital Diary
 */
/**
* Hook - digital_diary_action_doctype.
*
* @hooked digital_diary_doctype -  10
*/
do_action( 'digital_diary_action_doctype' );
?>
<head>
<?php
/**
* Hook - digital_diary_action_head.
*
* @hooked digital_diary_head -  10
*/
do_action( 'digital_diary_action_head' );
?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>

<?php

/**
* Hook - digital_diary_action_before.
*
* @hooked digital_diary_page_start - 10
*/
do_action( 'digital_diary_action_before' );

/**
*
* @hooked digital_diary_header_start - 10
*/
do_action( 'digital_diary_action_before_header' );

/**
*
*@hooked digital_diary_site_branding - 10
*@hooked digital_diary_header_end - 15 
*/
do_action('digital_diary_action_header');

/**
*
* @hooked digital_diary_content_start - 10
*/
do_action( 'digital_diary_action_before_content' );

/**
 * Banner start
 * 
 * @hooked digital_diary_banner_header - 10
*/
do_action( 'digital_diary_banner_header' );  
