<?php
/**
 * The template for displaying all single posts and attachments
 */

get_header();
digifly_page_header();
?>

<?php do_action( 'digifly_single_start' ); ?>

<div class="content-wrapper<?php echo digifly_wrapper_classes(); ?>">
	<div id="primary" class="content-area<?php echo digifly_primary_classes(); ?>">
		<main id="main" class="site-main" role="main">

		<?php
		// Start the loop.
		while ( have_posts() ) :
			the_post();

			// Include the single post content template.
			get_template_part( 'template-parts/content', 'single' );

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) {
				comments_template();
			}

			if ( is_singular( 'attachment' ) ) {
				// Parent post navigation.
				the_post_navigation(
					array(
						'prev_text' => _x( '<span class="meta-nav">Published in</span><span class="post-title">%title</span>', 'Parent post link', 'digifly' ),
					)
				);
			} elseif ( is_singular( 'post' ) ) {
				// Previous/next post navigation.
				the_post_navigation(
					array(
						'next_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Next', 'digifly' ) . '</span> ' .
							'<span class="screen-reader-text">' . __( 'Next post:', 'digifly' ) . '</span> ' .
							'<span class="post-title">%title</span>',
						'prev_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Previous', 'digifly' ) . '</span> ' .
							'<span class="screen-reader-text">' . __( 'Previous post:', 'digifly' ) . '</span> ' .
							'<span class="post-title">%title</span>',
					)
				);
			}

			// End of the loop.
		endwhile;
		?>

	</main>

	</div>

	<?php digifly_get_sidebar(); ?>

</div>

<?php get_footer(); ?>
