<?php 
/**
 *
 * @package markito-x
 * 
 * @since 1.0.4
 * 
*/
if ( ! class_exists( 'digicrew_lite_Theme_Back_To_Top_Section_Customizer' ) ) :

/**
   * Settings for customizer Back To Top Section 
**/
class digicrew_lite_Theme_Back_To_Top_Section_Customizer {

    public function __construct() {

        add_action( 'customize_register', array( $this, 'digicrew_lite_Back_To_Top_Section_customizer_options' ) );

    }

    /****
        * Customizer options
    ****/
    public function digicrew_lite_Back_To_Top_Section_customizer_options( $wp_customize ) {

        /*****
            * digicrew_lite Theme Back To Top Customizer Section 
        *****/
        $wp_customize->add_section(
            'digicrew_lite_Theme_Back_To_Top_Section',
            array(
                'title'    => esc_html__( 'Back To Top', 'digicrew_lite' ),
                'description' => __('Note ::- Here Section You Controll Back To Top Setting Of digicrew_lite Free Theme...','impulsive'),
                'priority' => 20,
            )
        );

        $wp_customize->add_setting('digicrew_lite_Back_To_Top_Section_Visibility',
            array(
                'sanitize_callback' => 'digicrew_lite_Back_To_Top_sanitize_checkbox_function',
                'default'           => 1,
            )
        );

        $wp_customize->add_control('digicrew_lite_Back_To_Top_Section_Visibility',
            array(
                'type'        => 'checkbox',
                'label'       => esc_html__('Enable Hide / Show Back To Top.', 'digicrew_lite'),
                'section'     => 'digicrew_lite_Theme_Back_To_Top_Section',
                'description' => esc_html__('Check this box to Enable Hide / Show Back To Top.', 'digicrew_lite'),
            )
        );

		$wp_customize->add_setting( 'digicrew_lite_Back_To_Top_Button_background', array(
			'default' => '#f05036',
			'sanitize_callback' => 'digicrew_lite_Back_To_Top_sanitize_color',
		));

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'digicrew_lite_Back_To_Top_Button_background', array(
			'label' => 'Button Background Color',
			'section' => 'digicrew_lite_Theme_Back_To_Top_Section',
			'settings' => 'digicrew_lite_Back_To_Top_Button_background'
		)));

		$wp_customize->add_setting( 'digicrew_lite_Back_To_Top_Button_color_background', array(
			'default' => '#fff',
			'sanitize_callback' => 'digicrew_lite_Back_To_Top_sanitize_color',
		));

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'digicrew_lite_Back_To_Top_Button_color_background', array(
			'label' => 'Button Icon Color',
			'section' => 'digicrew_lite_Theme_Back_To_Top_Section',
			'settings' => 'digicrew_lite_Back_To_Top_Button_color_background'
		)));

        $Back_To_Top_Location_Button = array(
            'Right' => 'Right',
            'Left' => 'Left',     
        );

        $wp_customize->add_setting( 'digicrew_lite_Back_To_Top_Location_Button', 
            array(
                'default' => 'Right',
                'sanitize_callback' => 'digicrew_lite_Back_To_Top_Sanitize_Text_Function',
            )
        );

        $wp_customize->add_control( 'digicrew_lite_Back_To_Top_Location_Button',
            array(
                'type' => 'select',
                'label' => __('Back To Top Button Location','digicrew_lite'),
                'section' => 'digicrew_lite_Theme_Back_To_Top_Section',
                'choices' => $Back_To_Top_Location_Button
            )
        );

		/**
		 * Color sanitization callback
		*/
		function digicrew_lite_Back_To_Top_sanitize_color( $color ) {
			if ( empty( $color ) || is_array( $color ) ) {
				return '';
			}

			// If string does not start with 'rgba', then treat as hex.
			// sanitize the hex color and finally convert hex to rgba
			if ( false === strpos( $color, 'rgba' ) ) {
				return sanitize_hex_color( $color );
			}

			// By now we know the string is formatted as an rgba color so we need to further sanitize it.
			$color = str_replace( ' ', '', $color );
			sscanf( $color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha );

			return 'rgba('.$red.','.$green.','.$blue.','.$alpha.')';
		}

        // markito x Theme Sanitize Function
        function digicrew_lite_Back_To_Top_Sanitize_Text_Function( $text ) {
            return sanitize_text_field( $text );
        }

        function digicrew_lite_Back_To_Top_sanitize_checkbox_function( $checked ) {
            // Boolean check.
            return ( ( isset( $checked ) && true == $checked ) ? true : false );
        }

    }

}
endif;
// Call Class 
new digicrew_lite_Theme_Back_To_Top_Section_Customizer(); 