<?php
/**
 * This is the child theme for digicrew theme.
 */

/* social icons walker */
require( dirname( __FILE__ ) . '/core/class_nav_social_walker.php' );

 /**
 * Customizers additions.
*/
require get_stylesheet_directory() . '/customizers.php';
/**
	 * For Welcome admin notice File...
	*/
	require get_stylesheet_directory() . '/inc/class-back-to-top-customize.php';

add_action( 'after_setup_theme', 'digicrew_lite_setup' );
function digicrew_lite_setup() {  

		if ( ! isset( $content_width ) ) $content_width = 900;
		
		/* theme support */
		add_theme_support( "title-tag" );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( "wp-block-styles" );
		$args =	array(
			'default-color' => 'ffffff',
			'default-image' => '',
		);
		add_theme_support( "custom-background", $args ); 
		add_theme_support( "align-wide" );
		add_theme_support( "post-thumbnails" );
		add_editor_style();
		
		if ( is_singular() ) wp_enqueue_script( "comment-reply" );
		
		register_nav_menus(
	        array(
	            'social' => __('Social Icon Menu Area', 'digicrew-lite')
	        )
	    );
}

function digicrew_lite_theme_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	    wp_enqueue_style( 'child-style',
	        get_stylesheet_directory_uri() . '/style.css',
	        array('parent-style')
	    );
}
add_action( 'wp_enqueue_scripts', 'digicrew_lite_theme_styles' );

function digicrew_lite_widgets_init() {
	register_sidebar(
		array(
	        'name'          => esc_html__('Footer Widget Area', 'digicrew'),
	        'id'            => 'footer-widget-area',
	        'description'   => esc_html__('footer widget area', 'digicrew'),
	        'before_widget' => '<div class="col-md-3 col-sm-6"><div id="%1$s" class="%2$s widget footer-box">',
	        'after_widget'  => '</div></div>',
	        'before_title'  => '<h3>',
	        'after_title'   => '</h3>',
	    )
	);
}
add_action( 'widgets_init', 'digicrew_lite_widgets_init' );