<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package digicrew-lite
 */

?>

	<!-- Footer-section -->
	<footer class="footer-bg">
	    <?php  if (is_active_sidebar('footer-widget-area')) { ?>
	        <div class="ws-section-spacing">
	            <div class="container">
	                <div class="row">
	                    <?php dynamic_sidebar('footer-widget-area'); ?>
	                </div>
	            </div>
	        </div>
	    <?php } ?>
	    <div class="copyright-area">
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-6">
	                    <p>
                        	<?php echo esc_html( gmdate( 'Y' ) ); ?> <?php echo esc_html( get_bloginfo( 'name' ) ); ?> <?php echo esc_html__( 'All rights reserved.', 'digicrew-lite' ); ?>
                        </p>
	                </div>
					<div class="col-lg-6">
						<div class="social center-social">
							<?php if ( has_nav_menu( 'social' ) ) : 
							wp_nav_menu(
								array(
									'theme_location' => 'social',
									'menu_class'     => 'social-network ',
									'walker' => new digicrewlite_Nav_Social_Walker(),
									'depth'          => 1,
									'link_before'    => '<span class="screen-reader-text">',
									'link_after'     => '</span>',
								)
							);
							endif; ?>
						</div>
					</div>
	            </div>
	        </div>
	    </div>
	</footer>
	<!-- End-footer-section -->
</div><!-- #page -->
<?php $digicrew_lite_Back_To_Top_Button_background = get_theme_mod('digicrew_lite_Back_To_Top_Button_background');
if( !empty($digicrew_lite_Back_To_Top_Button_background) ) : ?>

   <style>
      #btn-to-top {
         display: inline-block;
         width: 40px;
         height: 40px;
         background-color: <?php echo $digicrew_lite_Back_To_Top_Button_background; ?> !important;
         text-align: center;
         position: fixed;
         bottom: 90px;
         right: 35px;
         z-index: 999;
         transform: scale(1.1,1.1);
         transition: all 0.5s ease;
      }
   </style>    
                
<?php endif; ?>

<?php $digicrew_lite_Back_To_Top_Button_color_background = get_theme_mod('digicrew_lite_Back_To_Top_Button_color_background');
   if( !empty($digicrew_lite_Back_To_Top_Button_color_background) ) : ?>

      <style>

         a#btn-to-top i {
            font-size: 20px;
            color: <?php echo $digicrew_lite_Back_To_Top_Button_color_background; ?> !important;
            line-height: 2.1;
         }

      </style>    
                
<?php endif; ?>

<?php 
$digicrew_lite_Back_To_Top_Location_Button = get_theme_mod('digicrew_lite_Back_To_Top_Location_Button', 'Right'); 
if( $digicrew_lite_Back_To_Top_Location_Button === "Left" ) :
   ?>

   <style>
   #btn-to-top {
      opacity: 1;
      visibility: visible;
      left: 10%;
      position: fixed;
   }
   </style>  

   <?php

endif;
?>                             

<!--- scroll-to-top -->
<?php $digicrew_lite_Back_To_Top_Section_Visibility = get_theme_mod( 'digicrew_lite_Back_To_Top_Section_Visibility' ,1 );
if( $digicrew_lite_Back_To_Top_Section_Visibility ) : ?>
   <a href="#" id="btn-to-top"><i class="fas fa-arrow-up"></i></a>
<?php endif; ?>

<?php wp_footer(); ?>
</body>
</html>