<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package digicrew
*/

get_header();
?>
<!-- Banner-saction -->
<section class="banner-bg same-section-spacing">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="inner-banner-info pt-5">
                    <h2><?php esc_html_e('404 Error', 'digicrew'); ?></h2>
                </div>
            </div>

        </div>
        <nav aria-label="breadcrumb" class="breadcrumb-right">
            <ol class="breadcrumb">
                <?php if ( function_exists('digicrew_breadcrumbs') ){ 
                    digicrew_breadcrumbs(); 
                }?>
            </ol>
        </nav>
    </div>
</section>

<div class="page-not-found space">
    <div class="container">
        <div class="row">
            <div class="col-md-12 no-data">
                <h2>
                   <?php if ( get_theme_mod( "digicrew_Setting_For_404_Page_Section_Title" ) ) 
                    {
                        echo esc_html(get_theme_mod( "digicrew_Setting_For_404_Page_Section_Title" ));
                    } else{ 
                        echo esc_html__('404', 'digicrew');
                    }?> 
                    <?php //echo esc_html__('404', 'digicrew') ?></h2>
                <h4>
                    <?php if ( get_theme_mod( "digicrew_Setting_For_404_Page_Section_Description" ) ) 
                    {
                        echo esc_html(get_theme_mod( "digicrew_Setting_For_404_Page_Section_Description" ));
                    } else{ 
                        echo esc_html__('PAGE NOT FOUND', 'digicrew');
                    }?> 
                </h4>
                <?php $digicrew_404_Page_Button_background = get_theme_mod('digicrew_404_Page_Button_background');
                if( !empty($digicrew_404_Page_Button_background) ) : ?>

                    <style type="text/css" id="diwp-theme-option-css">
                        
                        .page-not-found .send-btn {
                           
                             border: 2px solid <?php echo $digicrew_404_Page_Button_background; ?> !important;
    padding: 9px 45px;
    display: inline-block;
    letter-spacing: 0.5px;
    border-radius: 30px;
    text-transform: capitalize;
    font-weight: 600;
    font-size: 16px;
    transition: all 0.3s ease-in-out 0s;
    -moz-transition: all 0.3s ease-in-out 0s;
    -o-transition: all 0.3s ease-in-out 0s;
    -webkit-transition: all 0.3s ease-in-out 0s;
    -ms-transition: all 0.3s ease-in-out 0s;

text-decoration: none;
                        }
						
						.send-btn:hover, .send-btn:focus {
    background-color: <?php echo $digicrew_404_Page_Button_background; ?> !important;
    color: #fff;
}
                    
                    </style>    
            
                <?php
            
                endif; ?>

                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class=" send-btn">
                    <?php if ( get_theme_mod( "digicrew_Setting_For_404_Page_Section_Button_Label" ) ) 
                    {
                        echo esc_html(get_theme_mod( "digicrew_Setting_For_404_Page_Section_Button_Label" ));
                    } else{ 
                        echo esc_html__('Back To Home', 'digicrew');
                    }?>  
                </a>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>