<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>
<form class="form-inline" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" >
	<div class="form-group">

		<input type="search" name="s" class="form-control mr5" id="woocommerce-product-search-field-<?php echo isset( $index ) ? absint( $index ) : 0; ?>" placeholder="<?php esc_attr_e( 'Search products&hellip;', 'di-responsive');  ?>" value="<?php echo get_search_query(); ?>" />

        <button type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'di-responsive' ); ?>" class="masterbtn form-control mr5 <?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ); ?>"><?php echo esc_html_x( 'Search', 'submit button', 'di-responsive' ); ?></button>

        <input type="hidden" name="post_type" value="product" />
	</div>
</form>
