<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dhaara
 */


$gallery_images = function_exists('get_field') ? get_field('gallery_images') : '';



if (is_single()) : ?>
    <!-- details start -->
    <article id="post-<?php the_ID(); ?>" <?php post_class('postbox__item format-image mb-50'); ?>>

        <!-- content start -->
        <div class="postbox__main-wrapper">
            <?php get_template_part('template-parts/blog/blog-details-meta'); ?>

            <div class="postbox__details-content-wrapper postbox__text mb-4 fix">
                <?php the_content(); ?>
                <?php
                wp_link_pages([
                    'before'      => '<div class="page-links">' . esc_html__('Pages:', 'dhaara'),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                ]);
                ?>
            </div>
        </div>
    </article>
    <!-- details end -->
<?php else : ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('postbox__item white-bg mb-50  '); ?>>

        <!-- if post has thumbnail -->
        <?php if (has_post_format('image')) : ?>
            <div class="postbox__thumb m-img">
                <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                </a>
            </div>
            <!-- if post has video -->
        <?php elseif (has_post_format('video')) : ?>
            <?php if (has_post_thumbnail()) : ?>
                <div class="postbox__thumb postbox__video m-img p-relative">

                    <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                    </a>

                </div>
            <?php endif; ?>

            <!-- if post has audio -->
        <?php elseif (has_post_format('audio')) : ?>



            <!-- if post has gallery -->
        <?php elseif (has_post_format('gallery')) : ?>
            <?php if (!empty($gallery_images)) : ?>
                <div class="postbox__thumb postbox__slider swiper-container m-img p-relative">
                    <div class="swiper-wrapper">
                        <?php foreach ($gallery_images as $key => $image) : ?>
                            <div class="postbox__slider-item swiper-slide">
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="postbox__nav">
                        <button class="postbox-slider-button-next"><i class="fa-regular fa-angle-right"></i></button>
                        <button class="postbox-slider-button-prev"><i class="fa-regular fa-angle-left"></i></button>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>
            <div class="postbox__thumb m-img ">
                <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                </a>
            </div>
        <?php endif; ?>
        <div class="postbox__content">
            <!-- blog meta -->
            <?php get_template_part('template-parts/blog/blog-meta'); ?>

            <h3 class="postbox__title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h3>
            <div class="postbox__text">
                <?php the_excerpt(); ?>
            </div>

            <!-- blog btn -->
            <?php get_template_part('template-parts/blog/blog-btn'); ?>
        </div>
    </article>
<?php endif; ?>