<?php

/**
 * @package dhaara
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
   <?php if (has_post_thumbnail()) { ?>
      <div class="post-thumb">
         <?php the_post_thumbnail(array(848, 450, 'bfi_thumb' => true)); ?>
      </div>
   <?php } ?>

   <!-- .entry-meta -->
   <div class="entry-content">
      <?php the_content(); ?>
      <?php
      wp_link_pages(array(
         'before'      => '<div class="page-links">' . esc_html__('Pages:', 'dhaara'),
         'after'       => '</div>',
         'link_before' => '<span class="page-number">',
         'link_after'  => '</span>',
      ));
      ?>
   </div>

   <?php if (get_theme_mod('post_meta_enable', post_meta_enable) == 1) { ?>
      <footer class="entry-footer">
         <div class="author-info">
            <div class="row">
               <div class="col-sm-2">
                  <?php echo get_avatar(get_the_author_meta('user_email'), $size = '120'); ?>
               </div>
               <div class="col-sm-10">
                  <h3><?php the_author_meta('user_nicename'); ?></h3>
                  <p><?php the_author_meta('description'); ?></p>
               </div>
            </div>
         </div>
      </footer>
   <?php } ?>
   <!-- .entry-footer -->
</article>
<!-- #post-## -->