<?php

/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dhaara
 */

if (is_single()) : ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class('postbox__item format-search mb-50'); ?>>

        <?php if (has_post_thumbnail()) : ?>
            <div class="postbox__thumb">
                <?php dhaara_post_thumbnail(); ?>
            </div>
        <?php endif; ?>

        <div class="postbox__content">
            <!-- blog meta -->
            <?php get_template_part('template-parts/blog/blog-meta'); ?>
            <h3 class="postbox__title">
                <?php the_title(); ?>
            </h3>
            <div class="postbox__text">
                <?php the_content(); ?>
                <?php
                wp_link_pages([
                    'before'      => '<div class="page-links">' . esc_html__('Pages:', 'dhaara'),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                ]);
                ?>
            </div>
            <?php print dhaara_get_tag(); ?>
        </div>
    </article>
<?php else : ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('search__blog-item mb-30'); ?>>
        <div class="postbox__thumb">
            <?php dhaara_post_thumbnail(); ?>
        </div>
        <div class="search__blog-content">

            <?php get_template_part('template-parts/blog/search-result-top-meta'); ?>

            <h3 class="search__blog-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h3>

            <?php the_excerpt(); ?>

            <?php get_template_part('template-parts/blog/search-result-meta'); ?>

            <?php get_template_part('template-parts/blog/blog-search-btn'); ?>

        </div>
    </article>
<?php endif; ?>


<!-- #post-<?php the_ID(); ?> -->