<?php

/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Dhaara
 */

?>
<section class="no-results not-found">


   <!-- .page-header -->
   <div class="container">
      <div class="row">
         <div class="col-xl-12">
            <div class="search-result-wrapper">
               <div class="search-result-content text-center mb-40">
                  <h3><?php esc_html_e('Nothing Found', 'dhaara'); ?></h3>
                  <?php
                  if (is_home() && current_user_can('publish_posts')) : ?>
                     <p><?php
                        printf(
                           wp_kses(
                              /* translators: 1: link to WP admin new post page. */
                              __('Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'dhaara'),
                              array(
                                 'a' => array(
                                    'href' => array(),
                                 ),
                              )
                           ),
                           esc_url(admin_url('post-new.php'))
                        );
                        ?></p>
                  <?php elseif (is_search()) : ?>
                     <p><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'dhaara'); ?></p>
               </div>
            </div>
         <?php
                     get_search_form();

                  else : ?>
            <p><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'dhaara'); ?></p>

         <?php
                     get_search_form();

                  endif; ?>
         </div>
      </div>
   </div>

   <!-- .page-content -->
</section>
<!-- .no-results -->