<?php

/**
 * Template part for displaying post btn
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dhaara
 */

$dhaara_search_btn = get_theme_mod( 'dhaara_blog_btn', 'Read More' );
$dhaara_search_btn_switch = get_theme_mod( 'dhaara_blog_btn_switch', true );

?>
 

<?php if ( !empty( $dhaara_search_btn_switch ) ): ?>
<div class="search__blog-btn">
    <a href="<?php the_permalink();?>" class=" group px-6 sm:px-8 py-3 sm:py-4 bg-primary-amber text-white font-semibold rounded-lg transition-all duration-300 hover:bg-amber-700 hover:scale-105 shadow-lg shadow-amber-200 inline-flex ">
        <?php print esc_html( $dhaara_search_btn );?>
        <span class="inline-flex items-center">
        <svg class="w-5 h-5 ml-2 transform group-hover:translate-x-2 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                    </svg>
        </span>
    </a>
</div>
<?php endif;?>