<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package dhaara
 */
$blog_column = is_active_sidebar('blog-sidebar') ? 8 : 12;
$categories = get_the_terms($post->ID, 'category');

if (function_exists('setPostViews')) {
	setPostViews(get_the_ID());
}
$breadcrumb = "";
if (!(empty($categories[0]->term_id))) {
	$breadcrumb = '<div class="breadcrumb-content p-relative z-index-1">
	<a href="' . esc_url(get_category_link($categories[0]->term_id)) . '">' . esc_html($categories[0]->name) . '</a>
	<a>/</a> <span>' . get_the_title() . '</span>
	</div>';
}
get_header();
?>

<section class="site-blog-area postbox-area grey-bg-4 pt-120 pb-120">
	<div class="container">
		<div class="row">
			<div class="col-xxl-12 max-w-7xl 2xl:max-w-8xl mx-auto">
				<div class="post-wrapper">

					<div class="postbox__main postbox__details-content-wrapper">
						<div class="row">

							<div class="col-lg-<?php echo esc_attr($blog_column); ?>">
								<?php
								while (have_posts()) :
									the_post();

									get_template_part('template-parts/content', get_post_format());

								?>
									<?php if (get_previous_post_link() and get_next_post_link()) :
										$prev_post = get_adjacent_post(false, '', true);
										$next_post = get_adjacent_post(false, '', false);
									?>

										<div class="postbox__more-navigation white-bg d-flex justify-content-between flex-wrap mb-40 ">
											<?php if (get_previous_post_link()) : ?>
												<div class="postbox__more-left d-flex align-items-center">
													<div class="postbox-more-icon">
														<a href="<?php echo get_permalink($prev_post->ID) ?>">
															<svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path d="M7 12.9718L2.06061 8.04401C1.47727 7.46205 1.47727 6.50975 2.06061 5.92778L7 1" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
															</svg>
														</a>
													</div>
													<div class="postbox__more-content">
														<p><?php print esc_html__('Previous Article', 'dhaara'); ?></p>
														<h4><?php print get_previous_post_link('%link ', '%title'); ?></h4>
													</div>
												</div>
											<?php endif; ?>

											<?php if (get_next_post_link()) : ?>
												<div class="postbox__more-right d-flex align-items-center justify-content-end">
													<div class="postbox__more-content">
														<p> <?php print esc_html__('Next Article', 'dhaara'); ?></p>
														<h4><?php print get_next_post_link('%link ', '%title'); ?></h4>
													</div>
													<div class="postbox-more-icon">
														<a href="<?php echo get_permalink($next_post->ID) ?>">
															<svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path d="M1 12.9718L5.93939 8.04401C6.52273 7.46205 6.52273 6.50975 5.93939 5.92778L1 1" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
															</svg>
														</a>
													</div>
												</div>
											<?php endif; ?>
										</div>

									<?php endif; ?> <!-- navigation end -->

								<?php
									get_template_part('template-parts/biography', get_post_format());

									// If comments are open or we have at least one comment, load up the comment template.
									if (comments_open() || get_comments_number()) :
										comments_template();
									endif;

								endwhile; // End of the loop.
								?>
							</div> <!-- end col 8 -->

							<?php if (is_active_sidebar('blog-sidebar')) : ?>
								<div class="col-lg-4">
									<div class="sidebar-wrapper  ">
										<?php get_sidebar(); ?>
									</div>
								</div> <!-- end col 4 -->
							<?php endif; ?>
						</div>
					</div> <!-- end main wrapper -->
				</div>
			</div>
		</div>
	</div>
</section>



<?php
get_footer();
