<?php

/**
 * Template for displaying search forms in dhaara
 *
 * @package WordPress
 * @subpackage dhaara
 * @since dhaara 1.0
 */
?>
<div class="search-result-form">
	<form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url('/')); ?>">
		<div class="search-result-input-box">
			<div class="search-result-input">
				<label>
					<span class="screen-reader-text"><?php echo _x('Search for:', 'label', 'dhaara'); ?></span>
					<input type="search" class="search-field" placeholder="<?php echo esc_attr_x('Search &hellip;', 'placeholder', 'dhaara'); ?>" value="<?php echo get_search_query(); ?>" name="s" />
				</label>
			</div>
			<button type="submit" class="wp-block-search-button wp-element-button"><?php echo esc_html__('Search', 'dhaara'); ?></button>

		</div>
	</form>