<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package dhaara
 */

get_header();

$blog_column = is_active_sidebar('blog-sidebar') ? 8 : 12;

$result = $wp_query->found_posts;


?>

<!-- search area start -->
<?php if (have_posts()) : ?>
	<section class="search-result-area grey-bg-4 pt-120 pb-80">
		<div class="container">
			<div class="row">
				<div class="col-xl-12">
					<div class="search-result-wrapper">
						<div class="search-result-content text-center mb-40">
							<h3 class="search-result-title"><?php esc_html_e('Search results for:', 'dhaara'); ?> <span><?php esc_html_e('“', 'dhaara'); ?><?php print get_search_query(); ?><?php esc_html_e('”', 'dhaara'); ?></span></h3>
							<p><?php echo esc_html__('Found', 'dhaara'); ?> <?php echo esc_html($result); ?> <?php echo esc_html__('results for your search query.', 'dhaara'); ?></p>

						</div>
						<div class="search-result-form">
							<form action="<?php print esc_url(home_url('/')); ?>">
								<div class="search-result-input-box">
									<div class="search-result-input">

										<input type="text" placeholder="<?php echo esc_attr('Search for articles...'); ?>" name="s" value="<?php print esc_attr(get_search_query()) ?>">
									</div>
									<button type="submit" class="wp-block-search-button wp-element-button"><?php echo esc_html__('Search', 'dhaara'); ?></button>

								</div>
								<div class="search-result-tags">
									<?php wp_tag_cloud(); ?>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php endif; ?>
<!-- search area end -->
<!-- search result item area start -->
<section class="dhaara-blog-area search-result-item-area pt-50 pb-50">
	<div class="container">
		<?php if (have_posts()) : ?>
			<div class="row  flex-start blog-list-row">
				<?php while (have_posts()) : the_post(); ?>
					<div class="col-md-6 grid-item">
						<?php get_template_part('template-parts/content', 'search'); ?>
					</div>
				<?php endwhile; ?>
			</div>
			<div class="row">
				<div class="col-xxl-12 max-w-7xl 2xl:max-w-8xl mx-auto">
					<div class="site-pagination mt-20">
						<?php site_pagination('<svg width="16" height="11" viewBox="0 0 16 11" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.17749 10.105L1.62499 5.55248L6.17749 0.999981" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M14.3767 5.55249L1.75421 5.55249" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/></svg>', '<svg width="16" height="11" viewBox="0 0 16 11" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.82422 1L14.3767 5.5525L9.82422 10.105" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M1.625 5.55249H14.2475" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/></svg>', '', ['class' => '']); ?>
					</div>
				</div>
			</div>

		<?php else :
			get_template_part('template-parts/content', 'none');
		endif;
		?>
	</div>
</section>
<!-- search result item area end -->
<?php
get_footer();
