<?php

/**
 * Template Name: Custom Home Page
 *
 * @package dhaara
 */

get_header();

// Get customizer values
$company_name = get_theme_mod('company_name', 'Dharā Architecture');
$company_description = get_theme_mod('company_description', 'Crafting innovative spaces that inspire and endure, transforming architectural visions into reality.');
$primary_color = get_theme_mod('primary_color', '#FFB600');

// Hero section customizer settings
$hero_badge_text = get_theme_mod('hero_badge_text', 'Premium Construction');
$hero_title = get_theme_mod('hero_title', 'Building <span style="color: ' . $primary_color . '">Excellence</span> in Every Detail');
$hero_description = get_theme_mod('hero_description', 'We combine innovative design with superior craftsmanship to create spaces that inspire. Our commitment to excellence ensures every project exceeds expectations.');
$hero_image = get_theme_mod('hero_image', '');
$hero_project_title = get_theme_mod('hero_project_title', 'The Horizon Tower');
$hero_project_description = get_theme_mod('hero_project_description', 'Award-winning architectural design in downtown metropolis');

// Hero floating cards
$hero_card_1_title = get_theme_mod('hero_card_1_title', 'Quality Assured');
$hero_card_1_desc = get_theme_mod('hero_card_1_desc', 'Premium materials and expert craftsmanship');
$hero_card_1_icon = get_theme_mod('hero_card_1_icon', 'fas fa-check-circle');
$hero_card_2_title = get_theme_mod('hero_card_2_title', 'Fast Delivery');
$hero_card_2_desc = get_theme_mod('hero_card_2_desc', 'On-time completion guaranteed');
$hero_card_2_icon = get_theme_mod('hero_card_2_icon', 'fas fa-bolt');

// Stats customizer settings
$stat_1_number = get_theme_mod('stat_1_number', '25');
$stat_1_text = get_theme_mod('stat_1_text', 'Years Experience');
$stat_2_number = get_theme_mod('stat_2_number', '350');
$stat_2_text = get_theme_mod('stat_2_text', 'Projects Done');
$stat_3_number = get_theme_mod('stat_3_number', '120');
$stat_3_text = get_theme_mod('stat_3_text', 'Expert Team');

// Buttons
$btn_1_text = get_theme_mod('hero_btn_1_text', 'View Projects');
$btn_1_url = get_theme_mod('hero_btn_1_url', '#');
$btn_2_text = get_theme_mod('hero_btn_2_text', 'Contact Us');
$btn_2_url = get_theme_mod('hero_btn_2_url', '#');

// About section
$about_background_text = get_theme_mod('about_background_text', 'ABOUT');
$about_title = get_theme_mod('about_title', 'Our Creative <span style="color: ' . $primary_color . '">Approach</span>');
$about_description = get_theme_mod('about_description', 'We\'re not just builders – we\'re innovators, dreamers, and problem-solvers pushing the boundaries of architectural possibilities.');

// Features
$feature_1_title = get_theme_mod('feature_1_title', 'Innovative Design');
$feature_1_desc = get_theme_mod('feature_1_desc', 'Pushing architectural boundaries with cutting-edge technology and creative solutions.');
$feature_2_title = get_theme_mod('feature_2_title', 'Sustainable Focus');
$feature_2_desc = get_theme_mod('feature_2_desc', 'Committed to eco-friendly practices and sustainable building solutions.');
$feature_3_title = get_theme_mod('feature_3_title', 'Expert Execution');
$feature_3_desc = get_theme_mod('feature_3_desc', 'Masterful craftsmanship delivered by industry-leading professionals.');

// About stats
$about_stat_1_number = get_theme_mod('about_stat_1_number', '25');
$about_stat_1_text = get_theme_mod('about_stat_1_text', 'Years of Innovation');
$about_stat_2_number = get_theme_mod('about_stat_2_number', '500');
$about_stat_2_text = get_theme_mod('about_stat_2_text', 'Projects Completed');

// Blog section
$blog_background_text = get_theme_mod('blog_background_text', 'BLOG');
$blog_title = get_theme_mod('blog_title', 'Latest <span style="color: ' . $primary_color . '">Insights</span>');
$blog_description = get_theme_mod('blog_description', 'Explore our thoughts on architecture, sustainability, and innovation in the built environment.');
$blog_posts_count = get_theme_mod('blog_posts_count', 3);

// Blog text elements
$blog_view_all_text = get_theme_mod('blog_view_all_text', 'View All Posts');
$blog_learn_more_text = get_theme_mod('blog_learn_more_text', 'Learn More');
$blog_no_posts_text = get_theme_mod('blog_no_posts_text', 'No blog posts found.');
$blog_reading_time_text = get_theme_mod('blog_reading_time_text', 'min read');
$blog_no_image_text = get_theme_mod('blog_no_image_text', 'No Image');

// Social media links
$social_media_links = json_decode(get_theme_mod('social_media_links', '[]'), true);


?>

<main id="tp_content" role="main">
    <!-- Hero Section -->
    <section class="hero-section relative 3xl:min-h-full w-full py-16 sm:py-20 lg:py-20 overflow-hidden">
        <!-- Background Elements -->
        <div class="absolute inset-0 -z-10">
            <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-12 lg:gap-20 items-start">
                <!-- Left Column -->
                <div class="space-y-6 sm:space-y-8">
                    <?php if ($hero_badge_text) : ?>
                        <div style="background-color: <?php echo esc_attr($primary_color); ?>40" class="inline-flex items-center gap-2 px-4 py-2 rounded-full shadow-sm fade-in-effect effect-1 is-visible">
                            <div style="background-color: <?php echo esc_attr($primary_color); ?>" class="h-2 w-2 rounded-full"></div>
                            <span style="color: <?php echo esc_attr($primary_color); ?>" class="font-medium text-sm sm:text-base"><?php echo esc_html($hero_badge_text); ?></span>
                        </div>
                    <?php endif; ?>

                    <h2 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 leading-tight fade-in-effect effect-2 is-visible">
                        <?php echo wp_kses_post($hero_title); ?>
                    </h2>

                    <p class="text-gray-600 text-base sm:text-lg max-w-xl fade-in-effect effect-3 is-visible">
                        <?php echo esc_html($hero_description); ?>
                    </p>

                    <!-- Stats -->
                    <div class="grid grid-cols-1 sm:grid-cols-3 py-6 sm:py-8 gap-6 sm:gap-8">
                        <div class="bg-white p-3 sm:p-4 rounded-xl hover:shadow-lg shadow-sm fade-in-effect effect-4 is-visible">
                            <div class="text-3xl sm:text-4xl font-bold text-gray-900 mb-2 text-center"><?php echo esc_html($stat_1_number); ?><span style="color: <?php echo esc_attr($primary_color); ?>">+</span></div>
                            <div class="text-sm sm:text-base text-gray-600 text-center"><?php echo esc_html($stat_1_text); ?></div>
                        </div>
                        <div class="bg-white p-3 sm:p-4 rounded-xl hover:shadow-lg shadow-sm fade-in-effect effect-5 is-visible">
                            <div class="text-3xl sm:text-4xl font-bold text-gray-900 mb-2 text-center"><?php echo esc_html($stat_2_number); ?><span style="color: <?php echo esc_attr($primary_color); ?>">+</span></div>
                            <div class="text-sm sm:text-base text-gray-600 text-center"><?php echo esc_html($stat_2_text); ?></div>
                        </div>
                        <div class="bg-white p-3 sm:p-4 rounded-xl hover:shadow-lg shadow-sm fade-in-effect effect-6 is-visible">
                            <div class="text-3xl sm:text-4xl font-bold text-gray-900 mb-2 text-center"><?php echo esc_html($stat_3_number); ?><span style="color: <?php echo esc_attr($primary_color); ?>">+</span></div>
                            <div class="text-sm sm:text-base text-gray-600 text-center"><?php echo esc_html($stat_3_text); ?></div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="flex flex-col sm:flex-row gap-6 sm:gap-8">
                        <a href="<?php echo esc_url($btn_1_url); ?>" style="background-color: <?php echo esc_attr($primary_color); ?>" class="group inline-flex items-center gap-2 px-6 sm:px-8 py-3 sm:py-4 text-white font-semibold rounded-lg transition-all duration-300 hover:scale-105 shadow-lg hover:shadow-xl is-visible">
                            <span class="inline-flex items-center">
                                <?php echo esc_html($btn_1_text); ?>
                                <svg class="w-5 h-5 ml-2 transform group-hover:translate-x-2 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                </svg>
                            </span>
                        </a>
                        <a href="<?php echo esc_url($btn_2_url); ?>" style="--hover-color: <?php echo esc_attr($primary_color); ?>;" class="px-6 sm:px-8 py-3 sm:py-4 border-2 border-gray-200 text-gray-700 font-semibold rounded-lg bg-white hover:scale-105 secondary-button fade-in-effect effect-2 text-center is-visible">
                            <?php echo esc_html($btn_2_text); ?>
                        </a>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="relative mt-8 lg:mt-0 fade-in-effect effect h-full is-visible">
                    <!-- Main Image with Overlay -->
                    <div class="relative rounded-2xl overflow-hidden shadow-2xl h-full">
                        <?php if (!empty($hero_image)) : ?>
                            <img decoding="async" src="<?php echo esc_url($hero_image); ?>" class="w-full !h-64 sm:!h-96 lg:!h-full object-cover static lg:absolute" alt="<?php echo esc_attr($hero_project_title); ?>">
                        <?php else : ?>
                            <div class="w-full !h-64 sm:!h-96 lg:!h-full bg-gray-200 flex items-center justify-center static lg:absolute">
                                <span class="text-gray-400"><?php echo esc_html($blog_no_image_text); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="absolute inset-0">
                            <div class="absolute bottom-4 sm:bottom-8 left-4 sm:left-8 right-4 sm:right-8">
                                <div class="bg-white/90 backdrop-blur-sm p-4 sm:p-6 rounded-xl">
                                    <h3 class="text-base sm:text-lg font-bold text-gray-900"><?php echo esc_html($hero_project_title); ?></h3>
                                    <p class="text-sm sm:text-base text-gray-600 mt-0"><?php echo esc_html($hero_project_description); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Floating Cards -->
                    <div class="hidden lg:flex flex-col absolute -left-12 top-1/4 transform -translate-y-1/4 gap-6 sm:gap-8">
                        <div class="float bg-white p-6 rounded-xl shadow-xl hover:shadow-2xl transition-shadow max-w-[270px]">
                            <div class="flex gap-2 items-center">
                                <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="w-12 h-12 rounded-full flex items-center justify-center">
                                    <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($hero_card_1_icon); ?>"></i>
                                </div>
                                <h4 class="font-semibold text-gray-900 text-base sm:text-lg"><?php echo esc_html($hero_card_1_title); ?></h4>
                            </div>
                            <p class="text-gray-600 mt-2"><?php echo esc_html($hero_card_1_desc); ?></p>
                        </div>
                        <div class="float bg-white p-6 rounded-xl shadow-xl hover:shadow-2xl transition-shadow max-w-[270px]">
                            <div class="flex gap-2 items-center">
                                <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="w-12 h-12 rounded-full flex items-center justify-center">
                                    <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($hero_card_2_icon); ?>"></i>
                                </div>
                                <h4 class="font-semibold text-gray-900 text-base sm:text-lg"><?php echo esc_html($hero_card_2_title); ?></h4>
                            </div>
                            <p class="text-gray-600 mt-2"><?php echo esc_html($hero_card_2_desc); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="about-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
        <!-- Background Elements -->
        <div class="absolute inset-0 -z-10">
            <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Section Header -->
            <div class="relative mb-12 sm:mb-16 text-center z-10">
                <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                    <?php echo esc_html($about_background_text); ?>
                </div>
                <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect is-visible">
                    <?php echo wp_kses_post($about_title); ?>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1 is-visible">
                    <?php echo esc_html($about_description); ?>
                </p>
            </div>

            <!-- Main Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 sm:gap-8">
                <!-- Left Column -->
                <div class="grid lg:col-span-5 gap-6 sm:gap-8">
                    <!-- Feature List -->
                    <div class="flex flex-col gap-6 sm:gap-8">
                        <div class="relative p-4 sm:p-6 bg-white rounded-2xl shadow-lg hover:shadow-xl fade-in-effect effect-1 is-visible">
                            <span style="background-color: <?php echo esc_attr($primary_color); ?>" class="absolute -left-2 sm:-left-4 -top-2 sm:-top-4 w-6 h-6 sm:w-8 sm:h-8 text-white flex items-center justify-center rounded-lg text-sm sm:text-base">1</span>
                            <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-2"><?php echo esc_html($feature_1_title); ?></h3>
                            <p class="text-sm sm:text-base text-gray-600"><?php echo esc_html($feature_1_desc); ?></p>
                        </div>
                        <div class="relative p-4 sm:p-6 bg-white rounded-2xl shadow-lg hover:shadow-xl fade-in-effect effect-2 is-visible">
                            <span style="background-color: <?php echo esc_attr($primary_color); ?>" class="absolute -left-2 sm:-left-4 -top-2 sm:-top-4 w-6 h-6 sm:w-8 sm:h-8 text-white flex items-center justify-center rounded-lg text-sm sm:text-base">2</span>
                            <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-2"><?php echo esc_html($feature_2_title); ?></h3>
                            <p class="text-sm sm:text-base text-gray-600"><?php echo esc_html($feature_2_desc); ?></p>
                        </div>
                        <div class="relative p-4 sm:p-6 bg-white rounded-2xl shadow-lg hover:shadow-xl fade-in-effect effect-3 is-visible">
                            <span style="background-color: <?php echo esc_attr($primary_color); ?>" class="absolute -left-2 sm:-left-4 -top-2 sm:-top-4 w-6 h-6 sm:w-8 sm:h-8 text-white flex items-center justify-center rounded-lg text-sm sm:text-base">3</span>
                            <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-2"><?php echo esc_html($feature_3_title); ?></h3>
                            <p class="text-sm sm:text-base text-gray-600"><?php echo esc_html($feature_3_desc); ?></p>
                        </div>
                    </div>

                    <!-- Stats Grid -->
                    <div class="grid grid-cols-2 gap-6 sm:gap-8 py-6 sm:py-0">
                        <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-lg hover:shadow-xl fade-in-effect is-visible">
                            <div style="color: <?php echo esc_attr($primary_color); ?>" class="text-3xl sm:text-4xl font-bold mb-2"><?php echo esc_html($about_stat_1_number); ?><span class="text-2xl sm:text-3xl">+</span></div>
                            <div class="text-sm sm:text-base text-gray-600"><?php echo esc_html($about_stat_1_text); ?></div>
                        </div>
                        <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-lg hover:shadow-xl fade-in-effect effect-1 is-visible">
                            <div style="color: <?php echo esc_attr($primary_color); ?>" class="text-3xl sm:text-4xl font-bold mb-2"><?php echo esc_html($about_stat_2_number); ?><span class="text-2xl sm:text-3xl">+</span></div>
                            <div class="text-sm sm:text-base text-gray-600"><?php echo esc_html($about_stat_2_text); ?></div>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Dynamic Images -->
                <div class="lg:col-span-7 mt-8 lg:mt-0">
                    <div class="grid grid-cols-12 h-full gap-6 sm:gap-8">
                        <!-- Left Images -->
                        <div class="col-span-12 sm:col-span-5 h-full flex flex-col gap-6 sm:gap-8">
                            <?php
                            $about_image_1 = get_theme_mod('about_image_1', '');
                            $about_image_1_title = get_theme_mod('about_image_1_title', 'Eco Residences');
                            $about_image_1_desc = get_theme_mod('about_image_1_desc', 'Modern sustainable living spaces');

                            $about_image_2 = get_theme_mod('about_image_2',  '');
                            $about_image_2_title = get_theme_mod('about_image_2_title', 'The Azure Tower');
                            $about_image_2_desc = get_theme_mod('about_image_2_desc', 'A 50-story sustainable skyscraper');
                            ?>

                            <!-- First Image -->
                            <div class="relative group flex-1 fade-in-effect rounded-2xl overflow-hidden is-visible">
                                <?php if (!empty($about_image_1)) : ?>
                                    <img decoding="async" src="<?php echo esc_url($about_image_1); ?>" alt="<?php echo esc_attr($about_image_1_title); ?>" class="md:absolute w-full md:!h-full !h-64 object-cover transform transition-transform duration-300 group-hover:scale-105">
                                <?php else : ?>
                                    <div class="md:absolute w-full md:!h-full !h-64 bg-gray-200 flex items-center justify-center transform transition-transform duration-300 group-hover:scale-105">
                                        <span class="text-gray-400"><?php echo esc_html($blog_no_image_text); ?></span>
                                    </div>
                                <?php endif; ?>
                                <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                    <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                        <h4 class="text-lg sm:text-xl font-bold text-white"><?php echo esc_html($about_image_1_title); ?></h4>
                                        <p class="text-sm sm:text-base text-white/80 mt-0"><?php echo esc_html($about_image_1_desc); ?></p>
                                    </div>
                                </div>
                            </div>

                            <!-- Second Image -->
                            <div class="relative group flex-1 fade-in-effect effect-1 rounded-2xl overflow-hidden is-visible">
                                <?php if (!empty($about_image_2)) : ?>
                                    <img decoding="async" src="<?php echo esc_url($about_image_2); ?>" alt="<?php echo esc_attr($about_image_2_title); ?>" class="md:absolute w-full md:!h-full !h-64 object-cover transform transition-transform duration-300 group-hover:scale-105">
                                <?php else : ?>
                                    <div class="md:absolute w-full md:!h-full !h-64 bg-gray-200 flex items-center justify-center transform transition-transform duration-300 group-hover:scale-105">
                                        <span class="text-gray-400"><?php echo esc_html($blog_no_image_text); ?></span>
                                    </div>
                                <?php endif; ?>
                                <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                    <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                        <h4 class="text-lg sm:text-xl font-bold text-white"><?php echo esc_html($about_image_2_title); ?></h4>
                                        <p class="text-sm sm:text-base text-white/80 mt-0"><?php echo esc_html($about_image_2_desc); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Right Side Content -->
                        <div class="col-span-12 sm:col-span-7 h-full flex flex-col gap-6 sm:gap-8">
                            <?php
                            $excellence_title = get_theme_mod('excellence_title', 'Excellence Recognized');
                            $excellence_desc = get_theme_mod('excellence_desc', 'Multiple international awards for architectural innovation');
                            $excellence_icon = get_theme_mod('excellence_icon', 'fas fa-star');

                            $about_main_image = get_theme_mod('about_main_image',  '');
                            $about_main_title = get_theme_mod('about_main_title', 'The Horizon Project');
                            $about_main_desc = get_theme_mod('about_main_desc', 'Award-winning sustainable design');
                            ?>

                            <!-- Excellence Box -->
                            <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-xl hover:shadow-2xl transition-all hover:-translate-y-1 fade-in-effect effect-2 is-visible">
                                <div style="background-color: <?php echo esc_attr($primary_color); ?>10" class="w-10 h-10 sm:w-12 sm:h-12 rounded-xl flex items-center justify-center mb-4">
                                    <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($excellence_icon); ?>"></i>
                                </div>
                                <h4 class="text-base sm:text-lg font-bold text-gray-900 mb-2"><?php echo esc_html($excellence_title); ?></h4>
                                <p class="text-xs sm:text-sm text-gray-600"><?php echo esc_html($excellence_desc); ?></p>
                            </div>

                            <!-- Main Featured Image -->
                            <div class="relative group flex-1 fade-in-effect effect-3 overflow-hidden rounded-2xl is-visible">
                                <?php if (!empty($about_main_image)) : ?>
                                    <img decoding="async" src="<?php echo esc_url($about_main_image); ?>" alt="<?php echo esc_attr($about_main_title); ?>" class="w-full min-h-80 md:!h-full !h-64 sm:!h-[600px] object-cover transform transition-transform duration-300 group-hover:scale-105 lg:absolute">
                                <?php else : ?>
                                    <div class="w-full min-h-80 md:!h-full !h-64 sm:!h-[600px] bg-gray-200 flex items-center justify-center transform transition-transform duration-300 group-hover:scale-105 lg:absolute">
                                        <span class="text-gray-400"><?php echo esc_html($blog_no_image_text); ?></span>
                                    </div>
                                <?php endif; ?>
                                <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                    <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                        <h4 class="text-lg sm:text-xl font-bold text-white"><?php echo esc_html($about_main_title); ?></h4>
                                        <p class="text-sm sm:text-base text-white/80 mt-0"><?php echo esc_html($about_main_desc); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- Blog Section -->
    <section class="blog-section relative py-16 sm:py-20 lg:py-20 overflow-hidden z-10">
        <!-- Background Elements -->
        <div class="absolute inset-0 -z-10">
            <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
                <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
            </div>
        </div>

        <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
            <!-- Section Header -->
            <div class="relative mb-24 text-center z-10">
                <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                    <?php echo esc_html($blog_background_text); ?>
                </div>
                <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect is-visible">
                    <?php echo wp_kses_post($blog_title); ?>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1 is-visible">
                    <?php echo esc_html($blog_description); ?>
                </p>
            </div>

            <!-- Dynamic Blog Posts -->
            <?php
            $blog_query = new WP_Query(array(
                'post_type' => 'post',
                'posts_per_page' => $blog_posts_count,
                'post_status' => 'publish'
            ));

            if ($blog_query->have_posts()) : ?>
                <div class="grid grid-cols-1 md:grid-cols-8 lg:grid-cols-12 gap-8">
                    <?php
                    $post_count = 0;
                    while ($blog_query->have_posts()) : $blog_query->the_post();
                        $post_count++;
                    ?>
                        <article class="md:col-span-4 group bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-xl fade-in-effect effect-<?php echo $post_count; ?> is-visible">
                            <div class="aspect-[4/3] overflow-hidden">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('large', array('class' => 'w-full h-full object-cover transform transition-transform duration-500 group-hover:scale-105')); ?>
                                <?php else : ?>
                                    <div class="w-full h-full bg-gray-200 flex items-center justify-center">
                                        <span class="text-gray-400"><?php echo esc_html($blog_no_image_text); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="p-6">
                                <div class="flex items-center gap-3 mb-3">
                                    <?php
                                    $categories = get_the_category();
                                    if (!empty($categories)) :
                                    ?>
                                        <span style="background-color: <?php echo esc_attr($primary_color); ?>20; color: <?php echo esc_attr($primary_color); ?>" class="px-3 py-1 rounded-full text-sm font-medium">
                                            <?php echo esc_html($categories[0]->name); ?>
                                        </span>
                                    <?php endif; ?>
                                    <span class="text-gray-500 text-sm"><?php echo esc_html(dhaara_reading_time(get_the_content())); ?> <?php echo esc_html($blog_reading_time_text); ?></span>
                                </div>
                                <h3 class="text-xl font-bold text-gray-900 mb-2 transition-colors">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h3>
                                <p class="text-gray-600 mb-4 line-clamp-2">
                                    <?php echo wp_trim_words(get_the_excerpt(), 20, '...'); ?>
                                </p>

                                <div class="flex items-center gap-3">
                                    <?php echo get_avatar(get_the_author_meta('ID'), 32, '', '', array('class' => 'w-8 h-8 rounded-full')); ?>
                                    <div class="text-sm">
                                        <div class="font-medium text-gray-900"><?php the_author(); ?></div>
                                        <div class="text-gray-500"><?php echo get_the_date(); ?></div>
                                    </div>
                                </div>
                                <a href="<?php the_permalink(); ?>" class="inline-flex items-center font-semibold group-hover:translate-x-2 transition-all duration-300 mt-4" style="color: <?php echo esc_attr($primary_color); ?>">
                                    <?php echo esc_html($blog_learn_more_text); ?>
                                    <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                    </svg>
                                </a>
                            </div>
                        </article>
                    <?php endwhile; ?>
                </div>

                <!-- View All Posts Button -->
                <div class="text-center mt-12 fade-in-effect is-visible">
                    <a href="<?php echo esc_url(get_permalink(get_option('page_for_posts'))); ?>" style="background-color: <?php echo esc_attr($primary_color); ?>; --hover-color: <?php echo esc_attr($primary_color); ?>;" class="group inline-flex items-center gap-2 px-6 sm:px-8 py-3 sm:py-4 text-white font-semibold rounded-lg transition-all duration-300 hover:scale-105 shadow-lg hover:shadow-xl">
                        <?php echo esc_html($blog_view_all_text); ?>
                        <svg class="w-5 h-5 transform group-hover:translate-x-2 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                        </svg>
                    </a>
                </div>
            <?php else : ?>
                <p class="text-center text-gray-600"><?php echo esc_html($blog_no_posts_text); ?></p>
            <?php endif;
            wp_reset_postdata(); ?>
        </div>
    </section>

</main>

<?php

get_footer();
