<?php

/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package dhaara
 */


if (!function_exists('site_pagination')) {

    function _dhaara_pagi_callback($pagination)
    {
        return $pagination;
    }

    //page navegation
    function site_pagination($prev, $next, $pages, $args)
    {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ($pages == '') {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if (!$pages) {
                $pages = 1;
            }
        }

        $pagination = [
            'base'      => add_query_arg('paged', '%#%'),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ($wp_rewrite->using_permalinks()) {
            $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
        }

        if (!empty($wp_query->query_vars['s'])) {
            $pagination['add_args'] = ['s' => get_query_var('s')];
        }

        $pagi = '';
        if (paginate_links($pagination) != '') {
            $paginations = paginate_links($pagination);
            $pagi .= '<ul>';
            foreach ($paginations as $key => $pg) {
                $pagi .= '<li>' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _dhaara_pagi_callback($pagi);
    }
}


// Helper function for reading time calculation
if (!function_exists('dhaara_reading_time')) {
    function dhaara_reading_time($content) {
        $word_count = str_word_count(strip_tags($content));
        $reading_time = ceil($word_count / 200); // Assuming 200 words per minute
        return max(1, $reading_time); // Minimum 1 minute
    }
}


function dhaara_body_classes($classes)
{

    // Adds a class of hfeed to non-singular pages.
    if (!is_singular()) {
        $classes[] = 'hfeed';
    }

    return $classes;
}
add_filter('body_class', 'dhaara_body_classes');


if (!function_exists('dhaara_post_thumbnail')) :
    /**
     * Displays an optional post thumbnail.
     *
     * Wraps the post thumbnail in an anchor element on index views, or a div
     * element when on single views.
     */
    function dhaara_post_thumbnail()
    {
        if (post_password_required() || is_attachment() || !has_post_thumbnail()) {
            return;
        }

        if (is_singular()) :
?>

            <div class="post-thumbnail">
                <?php the_post_thumbnail(); ?>
            </div><!-- .post-thumbnail -->

        <?php else : ?>

            <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
                <?php
                the_post_thumbnail('post-thumbnail', array(
                    'alt' => the_title_attribute(array(
                        'echo' => false,
                    )),
                ));
                ?>
            </a>

        <?php endif; // End is_singular().
    }
endif;


if (!function_exists('dhaara_entry_footer')) :
    /**
     * Prints HTML with meta information for the categories, tags and comments.
     */
    function dhaara_entry_footer()
    {
        // Hide category and tag text for pages.
        if ('post' === get_post_type()) {
            /* translators: used between list items, there is a space after the comma */
            $categories_list = get_the_category_list(esc_html__(', ', 'dhaara'));
            if ($categories_list) {
                /* translators: 1: list of categories. */
                printf('<span class="cat-links">' . esc_html__('Posted in %1$s', 'dhaara') . '</span>', $categories_list); // WPCS: XSS OK.
            }

            /* translators: used between list items, there is a space after the comma */
            $tags_list = get_the_tag_list('', esc_html_x(', ', 'list item separator', 'dhaara'));
            if ($tags_list) {
                /* translators: 1: list of tags. */
                printf('<span class="tags-links">' . esc_html__('Tagged %1$s', 'dhaara') . '</span>', $tags_list); // WPCS: XSS OK.
            }
        }

        if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) {
            echo '<span class="comments-link">';
            comments_popup_link(
                sprintf(
                    wp_kses(
                        /* translators: %s: post title */
                        __('Leave a Comment<span class="screen-reader-text"> on %s</span>', 'dhaara'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    get_the_title()
                )
            );
            echo '</span>';
        }
    }
endif;
/**
 * Get tags.
 */
function dhaara_get_tag()
{
    $html = '';
    if (has_tag()) {
        $html .= '<div class="tagcloud tagcloud-sm"><span>' . esc_html__('Post Tags : ', 'dhaara') . '</span>';
        $html .= get_the_tag_list('', ' ', '');
        $html .= '</div>';
    }
    return $html;
}


function getPostViews($postID)
{
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if ($count == '') {
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count;
}
function custom_footer_menu($menu_items, $args)
{
    $target_menus = ['footer-quick-links', 'footer-services'];

    if (in_array($args->theme_location, $target_menus)) {
        $dom = new DOMDocument();
        libxml_use_internal_errors(true); // Better error handling
        $dom->loadHTML('<ul class="space-y-4">' . $menu_items . '</ul>', LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
        libxml_clear_errors(); // Clear any errors

        foreach ($dom->getElementsByTagName('li') as $li) {
            $li->setAttribute('class', trim($li->getAttribute('class') . ' ms-0 group'));

            foreach ($li->getElementsByTagName('a') as $a) {
                $a->setAttribute('class', 'text-gray-400 hover:text-white transition-colors flex items-center gap-2');

                $span = $dom->createElement('span');
                $span->setAttribute('class', 'absolute right-[calc(100%+10px)] w-1.5 h-1.5 rounded-full bg-primary opacity-0 group-hover:opacity-100 transition-opacity');

                $a->insertBefore($span, $a->firstChild);
            }
        }

        return $dom->saveHTML();
    }
    return $menu_items;
}
add_filter('wp_nav_menu_items', 'custom_footer_menu', 10, 2);

/**
 * Comments
 * 
 */

if (!function_exists('dhaara_comment')) {
    function dhaara_comment($comment, $args, $depth)
    {
        $GLOBAL['comment'] = $comment;
        extract($args, EXTR_SKIP);
        $args['reply_text'] = 'Reply';
        $replayClass = 'comment-depth-' . esc_attr($depth);
        ?>
        <li id="comment-<?php comment_ID(); ?>">
            <div class="comments-box post-comment-box d-sm-flex align-items-start">
                <div class="post-comment-info">
                    <div class="post-comment-avater comments-avatar">
                        <?php print get_avatar($comment, 102, null, null, ['class' => []]); ?>
                    </div>
                </div>

                <div class="post-comment-text ">
                    <div class="post-comment-name">
                        <span class="post-meta"><?php comment_time(get_option('date_format')); ?></span>
                        <h5><?php print get_comment_author_link(); ?></h5>
                    </div>
                    <?php comment_text(); ?>
                    <div class="post-comment-reply">
                        <?php comment_reply_link(array_merge($args, ['depth' => $depth, 'max_depth' => $args['max_depth']])); ?>
                    </div>
                </div>
            </div>
    <?php
    }
}

add_filter('nav_menu_link_attributes', 'hash_link_scroll_attr', 10, 3);
function hash_link_scroll_attr($atts, $item, $args)
{
    $link = $atts['href'];
    if (!filter_var($link, FILTER_VALIDATE_URL)) {
        $atts['data-scrol'] = str_replace("#", "", $atts['href']);
        $atts['href'] =  '#';
    }
    return $atts;
}
