/**
 * Complete Customizer JavaScript
 * Includes existing switch functionality + new live preview features
 */

jQuery(document).ready(function($) {
    'use strict';
    
    // Existing switch functionality
    $('.switch_options').each(function() {
        //This object
        var obj = $(this);

        var enb = obj.children('.switch_enable'); //cache first element, this is equal to ON
        var dsb = obj.children('.switch_disable'); //cache first element, this is equal to OFF
        var input = obj.children('input'); //cache the element where we must set the value
        var input_val = obj.children('input').val(); //cache the element where we must set the value

        /* Check selected */
        if (0 == input_val) {
            dsb.addClass('selected');
        }
        else if (1 == input_val) {
            enb.addClass('selected');
        }

        //Action on user's click(ON)
        enb.on('click', function() {
            $(dsb).removeClass('selected'); //remove "selected" from other elements in this object class(OFF)
            $(this).addClass('selected'); //add "selected" to the element which was just clicked in this object class(ON) 
            $(input).val(1).change(); //Finally change the value to 1
        });

        //Action on user's click(OFF)
        dsb.on('click', function() {
            $(enb).removeClass('selected'); //remove "selected" from other elements in this object class(ON)
            $(this).addClass('selected'); //add "selected" to the element which was just clicked in this object class(OFF) 
            $(input).val(0).change(); // //Finally change the value to 0
        });
    });

    // Social Media Links Functionality
    function initSocialMediaControls() {
        var container = $('.social-media-links-container');
        
        // Add new social media item
        container.on('click', '.add-social-media', function(e) {
            e.preventDefault();
            var list = container.find('.social-media-links-list');
            var index = list.children().length;
            
            var newItem = $('<div class="social-media-item" data-index="' + index + '">' +
                '<input type="text" class="platform" placeholder="Platform Name" />' +
                '<input type="text" class="icon-picker" placeholder="Select Icon" />' +
                '<input type="url" class="url" placeholder="URL" />' +
                '<button class="remove-social-media button-secondary" type="button">Remove</button>' +
                '</div>');
            
            list.append(newItem);
            initIconPicker(newItem.find('.icon-picker'));
            updateSocialMediaValue();
        });
        
        // Remove social media item
        container.on('click', '.remove-social-media', function(e) {
            e.preventDefault();
            $(this).closest('.social-media-item').remove();
            updateSocialMediaValue();
        });
        
        // Update value when inputs change
        container.on('input', '.platform, .icon-picker, .url', function() {
            updateSocialMediaValue();
        });
        
        // Initialize existing icon pickers
        container.find('.icon-picker').each(function() {
            initIconPicker($(this));
        });
    }
    
    function initIconPicker(element) {
        if (typeof $.fn.iconpicker !== 'undefined') {
            element.iconpicker({
                theme: 'fam',
                iconset: 'fontawesome5',
                animation: false,
                placement: 'bottom'
            });
            
            element.on('iconpickerSelected', function() {
                updateSocialMediaValue();
            });
        }
    }
    
    function updateSocialMediaValue() {
        var container = $('.social-media-links-container');
        var items = [];
        
        container.find('.social-media-item').each(function() {
            var item = $(this);
            var platform = item.find('.platform').val();
            var icon = item.find('.icon-picker').val();
            var url = item.find('.url').val();
            
            if (platform && icon && url) {
                items.push({
                    platform: platform,
                    icon: icon,
                    url: url
                });
            }
        });
        
        var hiddenInput = container.find('input[type="hidden"]');
        hiddenInput.val(JSON.stringify(items)).trigger('change');
    }
    
    // Initialize social media controls
    initSocialMediaControls();
});

/**
 * Customizer Live Preview JavaScript
 * This part runs in the preview frame
 */
(function($) {
    'use strict';

    // Only run in customizer preview
    if (typeof wp === 'undefined' || typeof wp.customize === 'undefined') {
        return;
    }

    // Primary Color
    wp.customize('primary_color', function(value) {
        value.bind(function(newval) {
            // Update CSS custom property
            if ($(':root').length) {
                $(':root').get(0).style.setProperty('--primary-color', newval);
            }
            
            // Update inline styles throughout the page
            $('[style*="background-color: #FFB600"], [style*="background-color:#FFB600"]').each(function() {
                var currentStyle = $(this).attr('style');
                if (currentStyle) {
                    var newStyle = currentStyle.replace(/#FFB600/gi, newval);
                    $(this).attr('style', newStyle);
                }
            });
            
            $('[style*="color: #FFB600"], [style*="color:#FFB600"]').each(function() {
                var currentStyle = $(this).attr('style');
                if (currentStyle) {
                    var newStyle = currentStyle.replace(/#FFB600/gi, newval);
                    $(this).attr('style', newStyle);
                }
            });
        });
    });

    // Company Information
    wp.customize('company_name', function(value) {
        value.bind(function(newval) {
            $('.company-name').text(newval);
        });
    });

    wp.customize('company_description', function(value) {
        value.bind(function(newval) {
            $('.company-description').text(newval);
        });
    });

    // Hero Section
    wp.customize('hero_badge_text', function(value) {
        value.bind(function(newval) {
            $('.hero-section .inline-flex .font-medium').text(newval);
        });
    });

    wp.customize('hero_title', function(value) {
        value.bind(function(newval) {
            $('.hero-section h2.text-4xl').html(newval);
        });
    });

    wp.customize('hero_description', function(value) {
        value.bind(function(newval) {
            $('.hero-section .text-gray-600.text-base.sm\\:text-lg').text(newval);
        });
    });

    wp.customize('hero_project_title', function(value) {
        value.bind(function(newval) {
            $('.hero-section .bg-white\\/90 h3').text(newval);
        });
    });

    wp.customize('hero_project_description', function(value) {
        value.bind(function(newval) {
            $('.hero-section .bg-white\\/90 p').text(newval);
        });
    });

    // Hero Buttons
    wp.customize('hero_btn_1_text', function(value) {
        value.bind(function(newval) {
            $('.hero-section .primary-button .inline-flex').contents().filter(function() {
                return this.nodeType === 3; // Text node
            }).first().replaceWith(newval + ' ');
        });
    });

    wp.customize('hero_btn_1_url', function(value) {
        value.bind(function(newval) {
            $('.hero-section .primary-button').attr('href', newval);
        });
    });

    wp.customize('hero_btn_2_text', function(value) {
        value.bind(function(newval) {
            $('.hero-section .secondary-button').text(newval);
        });
    });

    wp.customize('hero_btn_2_url', function(value) {
        value.bind(function(newval) {
            $('.hero-section .secondary-button').attr('href', newval);
        });
    });

    // Hero Stats
    wp.customize('stat_1_number', function(value) {
        value.bind(function(newval) {
            var primaryColor = wp.customize('primary_color')();
            $('.hero-section .grid.grid-cols-1.sm\\:grid-cols-3 .bg-white:nth-child(1) .text-3xl').html(newval + '<span style="color: ' + primaryColor + '">+</span>');
        });
    });

    wp.customize('stat_1_text', function(value) {
        value.bind(function(newval) {
            $('.hero-section .grid.grid-cols-1.sm\\:grid-cols-3 .bg-white:nth-child(1) .text-gray-600').text(newval);
        });
    });

    wp.customize('stat_2_number', function(value) {
        value.bind(function(newval) {
            var primaryColor = wp.customize('primary_color')();
            $('.hero-section .grid.grid-cols-1.sm\\:grid-cols-3 .bg-white:nth-child(2) .text-3xl').html(newval + '<span style="color: ' + primaryColor + '">+</span>');
        });
    });

    wp.customize('stat_2_text', function(value) {
        value.bind(function(newval) {
            $('.hero-section .grid.grid-cols-1.sm\\:grid-cols-3 .bg-white:nth-child(2) .text-gray-600').text(newval);
        });
    });

    wp.customize('stat_3_number', function(value) {
        value.bind(function(newval) {
            var primaryColor = wp.customize('primary_color')();
            $('.hero-section .grid.grid-cols-1.sm\\:grid-cols-3 .bg-white:nth-child(3) .text-3xl').html(newval + '<span style="color: ' + primaryColor + '">+</span>');
        });
    });

    wp.customize('stat_3_text', function(value) {
        value.bind(function(newval) {
            $('.hero-section .grid.grid-cols-1.sm\\:grid-cols-3 .bg-white:nth-child(3) .text-gray-600').text(newval);
        });
    });

    // About Section
    wp.customize('about_title', function(value) {
        value.bind(function(newval) {
            $('.about-section h2.relative').html(newval);
        });
    });

    wp.customize('about_description', function(value) {
        value.bind(function(newval) {
            $('.about-section .text-xl.text-gray-600.max-w-2xl').text(newval);
        });
    });

    // Features
    wp.customize('feature_1_title', function(value) {
        value.bind(function(newval) {
            $('.about-section .flex-col .relative:nth-child(1) h3').text(newval);
        });
    });

    wp.customize('feature_1_desc', function(value) {
        value.bind(function(newval) {
            $('.about-section .flex-col .relative:nth-child(1) p').text(newval);
        });
    });

    wp.customize('feature_2_title', function(value) {
        value.bind(function(newval) {
            $('.about-section .flex-col .relative:nth-child(2) h3').text(newval);
        });
    });

    wp.customize('feature_2_desc', function(value) {
        value.bind(function(newval) {
            $('.about-section .flex-col .relative:nth-child(2) p').text(newval);
        });
    });

    wp.customize('feature_3_title', function(value) {
        value.bind(function(newval) {
            $('.about-section .flex-col .relative:nth-child(3) h3').text(newval);
        });
    });

    wp.customize('feature_3_desc', function(value) {
        value.bind(function(newval) {
            $('.about-section .flex-col .relative:nth-child(3) p').text(newval);
        });
    });

    // About Stats
    wp.customize('about_stat_1_number', function(value) {
        value.bind(function(newval) {
            var primaryColor = wp.customize('primary_color')();
            $('.about-section .grid.grid-cols-2 .bg-white:nth-child(1) div[style*="color"]').html(newval + '<span class="text-2xl sm:text-3xl">+</span>');
        });
    });

    wp.customize('about_stat_1_text', function(value) {
        value.bind(function(newval) {
            $('.about-section .grid.grid-cols-2 .bg-white:nth-child(1) .text-gray-600').text(newval);
        });
    });

    wp.customize('about_stat_2_number', function(value) {
        value.bind(function(newval) {
            var primaryColor = wp.customize('primary_color')();
            $('.about-section .grid.grid-cols-2 .bg-white:nth-child(2) div[style*="color"]').html(newval + '<span class="text-2xl sm:text-3xl">+</span>');
        });
    });

    wp.customize('about_stat_2_text', function(value) {
        value.bind(function(newval) {
            $('.about-section .grid.grid-cols-2 .bg-white:nth-child(2) .text-gray-600').text(newval);
        });
    });

    // Blog Section
    wp.customize('blog_title', function(value) {
        value.bind(function(newval) {
            $('.blog-section h2.relative').html(newval);
        });
    });

    wp.customize('blog_description', function(value) {
        value.bind(function(newval) {
            $('.blog-section .text-xl.text-gray-600.max-w-2xl').text(newval);
        });
    });

    // Newsletter Section
    wp.customize('newsletter_title', function(value) {
        value.bind(function(newval) {
            $('.newsletter-section h2').text(newval);
        });
    });

    wp.customize('newsletter_description', function(value) {
        value.bind(function(newval) {
            $('.newsletter-section .text-xl.text-gray-600').text(newval);
        });
    });

    // Contact Information
    wp.customize('contact_email', function(value) {
        value.bind(function(newval) {
            $('.contact-email').text(newval);
            $('a[href^="mailto:"]').attr('href', 'mailto:' + newval);
        });
    });

    wp.customize('contact_phone', function(value) {
        value.bind(function(newval) {
            $('.contact-phone').text(newval);
            $('a[href^="tel:"]').attr('href', 'tel:' + newval);
        });
    });

})(jQuery);

/**
 * About Images Live Preview JavaScript
 * Add this to your existing customizer JavaScript file
 */

// About Images Live Preview
(function($) {
    'use strict';

    // Only run in customizer preview
    if (typeof wp === 'undefined' || typeof wp.customize === 'undefined') {
        return;
    }

    // About Image 1 Title
    wp.customize('about_image_1_title', function(value) {
        value.bind(function(newval) {
            $('.about-section .col-span-12.sm\\:col-span-5 .relative:first-child h4').text(newval);
        });
    });

    // About Image 1 Description
    wp.customize('about_image_1_desc', function(value) {
        value.bind(function(newval) {
            $('.about-section .col-span-12.sm\\:col-span-5 .relative:first-child p').text(newval);
        });
    });

    // About Image 2 Title
    wp.customize('about_image_2_title', function(value) {
        value.bind(function(newval) {
            $('.about-section .col-span-12.sm\\:col-span-5 .relative:last-child h4').text(newval);
        });
    });

    // About Image 2 Description
    wp.customize('about_image_2_desc', function(value) {
        value.bind(function(newval) {
            $('.about-section .col-span-12.sm\\:col-span-5 .relative:last-child p').text(newval);
        });
    });

    // Excellence Box Title
    wp.customize('excellence_title', function(value) {
        value.bind(function(newval) {
            $('.about-section .bg-white.p-4 h4').text(newval);
        });
    });

    // Excellence Box Description
    wp.customize('excellence_desc', function(value) {
        value.bind(function(newval) {
            $('.about-section .bg-white.p-4 p').text(newval);
        });
    });

    // Excellence Box Icon
    wp.customize('excellence_icon', function(value) {
        value.bind(function(newval) {
            $('.about-section .bg-white.p-4 i').attr('class', newval);
        });
    });

    // About Main Image Title
    wp.customize('about_main_title', function(value) {
        value.bind(function(newval) {
            $('.about-section .col-span-12.sm\\:col-span-7 .relative.group h4').text(newval);
        });
    });

    // About Main Image Description
    wp.customize('about_main_desc', function(value) {
        value.bind(function(newval) {
            $('.about-section .col-span-12.sm\\:col-span-7 .relative.group p').text(newval);
        });
    });

})(jQuery);