<?php

/**
 * dhaara customizer
 *
 * @package dhaara
 */

/**
 * Custom Control for Social Media Links
 */
if (class_exists('WP_Customize_Control')) {
    class Social_Media_Links_Control extends WP_Customize_Control
    {
        public $type = 'social_media_links';

        public function enqueue()
        {
            // Load media uploader scripts
            wp_enqueue_media();

            // Load custom control styles
            wp_enqueue_style('customizer-style', get_template_directory_uri() . '/inc/css/customizer-style.css', array());

            // Load existing scripts
            if (!wp_script_is('fontawesome-iconpicker', 'enqueued')) {
                wp_enqueue_script('fontawesome-iconpicker', DHAARA_THEME_ROOT . '/assets/js/fontawesome-iconpicker.min.js', array('jquery'), '3.2.0', true);
            }
            wp_enqueue_style('fontawesome-iconpicker', DHAARA_THEME_ROOT . '/assets/font/fontawesome-iconpicker.min.css');
            wp_enqueue_style('fontawesome', DHAARA_THEME_ROOT . '/assets/font/fontawesome.min.css');
            wp_enqueue_script('social-media-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array('jquery', 'fontawesome-iconpicker'), '1.0', true);
        }

        public function render_content()
        {
            $values = json_decode($this->value(), true);
            if (!is_array($values)) {
                $values = array();
            }
?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <div class="social-media-links-container">
                    <div class="social-media-links-list">
                        <?php foreach ($values as $index => $item) : ?>
                            <div class="social-media-item" data-index="<?php echo esc_attr($index); ?>">
                                <input type="text" class="platform" value="<?php echo esc_attr($item['platform']); ?>" placeholder="Platform Name" />
                                <input type="text" class="icon-picker" value="<?php echo esc_attr($item['icon']); ?>" placeholder="Select Icon" />
                                <input type="url" class="url" value="<?php echo esc_url($item['url']); ?>" placeholder="URL" />
                                <button class="remove-social-media" type="button">Remove</button>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <button class="add-social-media button-secondary" type="button">Add Social Media</button>
                    <input type="hidden" id="<?php echo esc_attr($this->id); ?>" name="<?php echo esc_attr($this->id); ?>" value="<?php echo esc_attr($this->value()); ?>" <?php $this->link(); ?> />
                </div>
            </label>
    <?php
        }
    }
}

/**
 * Register Customizer Settings
 */
function dhaara_customize_register($wp_customize)
{
    /**
     * Add Custom Home Panel
     */
    $wp_customize->add_panel('dhaara_custom_home', array(
        'title'       => __('Custom Home', 'dhaara'),
        'description' => __('Customize your homepage sections and content', 'dhaara'),
        'priority'    => 5,
    ));

    /**
     * Company Information Section
     */
    $wp_customize->add_section('dhaara_company_info', array(
        'title'    => __('Company Information', 'dhaara'),
        'priority' => 30,
    ));

    // Company Name
    $wp_customize->add_setting('company_name', array(
        'default'           => 'Dharā Architecture',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('company_name', array(
        'label'    => __('Company Name', 'dhaara'),
        'section'  => 'dhaara_company_info',
        'type'     => 'text'
    ));

    // Company Description
    $wp_customize->add_setting('company_description', array(
        'default'           => 'Crafting innovative spaces that inspire and endure, transforming architectural visions into reality.',
        'sanitize_callback' => 'sanitize_textarea_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('company_description', array(
        'label'    => __('Company Description', 'dhaara'),
        'section'  => 'dhaara_company_info',
        'type'     => 'textarea'
    ));

    /**
     * Contact Information Section
     */
    $wp_customize->add_section('dhaara_contact_info', array(
        'title'    => __('Contact Information', 'dhaara'),
        'priority' => 31,
    ));

    // Email
    $wp_customize->add_setting('contact_email', array(
        'default'           => 'info@example.com',
        'sanitize_callback' => 'sanitize_email',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('contact_email', array(
        'label'    => __('Contact Email', 'dhaara'),
        'section'  => 'dhaara_contact_info',
        'type'     => 'email'
    ));

    // Phone
    $wp_customize->add_setting('contact_phone', array(
        'default'           => '+1 (234) 567-890',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('contact_phone', array(
        'label'    => __('Contact Phone', 'dhaara'),
        'section'  => 'dhaara_contact_info',
        'type'     => 'text'
    ));

    /**
     * Social Media Section
     */
    $wp_customize->add_section('dhaara_social_media', array(
        'title'    => __('Social Media Links', 'dhaara'),
        'priority' => 32,
    ));

    // Social Media Links (repeater)
    $wp_customize->add_setting('social_media_links', array(
        'default'           => json_encode(array(
            array(
                'platform' => 'twitter',
                'icon' => 'fab fa-twitter',
                'url' => '#'
            ),
            array(
                'platform' => 'instagram',
                'icon' => 'fab fa-instagram',
                'url' => '#'
            )
        )),
        'sanitize_callback' => 'dhaara_sanitize_social_links',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control(new Social_Media_Links_Control($wp_customize, 'social_media_links', array(
        'label'    => __('Social Media Links', 'dhaara'),
        'section'  => 'dhaara_social_media',
        'settings' => 'social_media_links'
    )));

    /**
     * Hero Section
     */
    $wp_customize->add_section('dhaara_hero_section', array(
        'title'    => __('Hero Section', 'dhaara'),
        'panel'    => 'dhaara_custom_home',
        'priority' => 40,
    ));

    // Hero Badge Text
    $wp_customize->add_setting('hero_badge_text', array(
        'default'           => 'Premium Construction',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_badge_text', array(
        'label'    => __('Hero Badge Text', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'text'
    ));

    // Hero Title
    $wp_customize->add_setting('hero_title', array(
        'default'           => 'Building <span style="color: var(--primary-color)">Excellence</span> in Every Detail',
        'sanitize_callback' => 'wp_kses_post',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_title', array(
        'label'       => __('Hero Title', 'dhaara'),
        'description' => __('You can use HTML tags like <span> for styling', 'dhaara'),
        'section'     => 'dhaara_hero_section',
        'type'        => 'textarea'
    ));

    // Hero Description
    $wp_customize->add_setting('hero_description', array(
        'default'           => 'We combine innovative design with superior craftsmanship to create spaces that inspire. Our commitment to excellence ensures every project exceeds expectations.',
        'sanitize_callback' => 'sanitize_textarea_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_description', array(
        'label'    => __('Hero Description', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'textarea'
    ));

    // Hero Image
    $wp_customize->add_setting('hero_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'hero_image', array(
        'label'    => __('Hero Image', 'dhaara'),
        'section'  => 'dhaara_hero_section'
    )));

    // Hero Project Title
    $wp_customize->add_setting('hero_project_title', array(
        'default'           => 'The Horizon Tower',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_project_title', array(
        'label'    => __('Featured Project Title', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'text'
    ));

    // Hero Project Description
    $wp_customize->add_setting('hero_project_description', array(
        'default'           => 'Award-winning architectural design in downtown metropolis',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_project_description', array(
        'label'    => __('Featured Project Description', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'text'
    ));

    // Hero Button 1 Text
    $wp_customize->add_setting('hero_btn_1_text', array(
        'default'           => 'View Projects',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_btn_1_text', array(
        'label'    => __('Primary Button Text', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'text'
    ));

    // Hero Button 1 URL
    $wp_customize->add_setting('hero_btn_1_url', array(
        'default'           => '#',
        'sanitize_callback' => 'esc_url_raw',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_btn_1_url', array(
        'label'    => __('Primary Button URL', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'url'
    ));

    // Hero Button 2 Text
    $wp_customize->add_setting('hero_btn_2_text', array(
        'default'           => 'Contact Us',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_btn_2_text', array(
        'label'    => __('Secondary Button Text', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'text'
    ));

    // Hero Button 2 URL
    $wp_customize->add_setting('hero_btn_2_url', array(
        'default'           => '#',
        'sanitize_callback' => 'esc_url_raw',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_btn_2_url', array(
        'label'    => __('Secondary Button URL', 'dhaara'),
        'section'  => 'dhaara_hero_section',
        'type'     => 'url'
    ));

    /**
     * Hero Stats Section
     */
    $wp_customize->add_section('dhaara_stats_section', array(
        'title'    => __('Hero Stats', 'dhaara'),
        'panel'    => 'dhaara_custom_home',
        'priority' => 50,
    ));

    // Stat 1
    $wp_customize->add_setting('stat_1_number', array(
        'default'           => '25',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('stat_1_number', array(
        'label'    => __('Stat 1 Number', 'dhaara'),
        'section'  => 'dhaara_stats_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('stat_1_text', array(
        'default'           => 'Years Experience',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('stat_1_text', array(
        'label'    => __('Stat 1 Text', 'dhaara'),
        'section'  => 'dhaara_stats_section',
        'type'     => 'text'
    ));

    // Stat 2
    $wp_customize->add_setting('stat_2_number', array(
        'default'           => '350',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('stat_2_number', array(
        'label'    => __('Stat 2 Number', 'dhaara'),
        'section'  => 'dhaara_stats_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('stat_2_text', array(
        'default'           => 'Projects Done',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('stat_2_text', array(
        'label'    => __('Stat 2 Text', 'dhaara'),
        'section'  => 'dhaara_stats_section',
        'type'     => 'text'
    ));

    // Stat 3
    $wp_customize->add_setting('stat_3_number', array(
        'default'           => '120',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('stat_3_number', array(
        'label'    => __('Stat 3 Number', 'dhaara'),
        'section'  => 'dhaara_stats_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('stat_3_text', array(
        'default'           => 'Expert Team',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('stat_3_text', array(
        'label'    => __('Stat 3 Text', 'dhaara'),
        'section'  => 'dhaara_stats_section',
        'type'     => 'text'
    ));

    /**
     * About Section
     */
    $wp_customize->add_section('dhaara_about_section', array(
        'title'    => __('About Section', 'dhaara'),
        'panel'    => 'dhaara_custom_home',
        'priority' => 60,
    ));

    // About Background Text
    $wp_customize->add_setting('about_background_text', array(
        'default'           => 'ABOUT',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_background_text', array(
        'label'       => __('About Background Text', 'dhaara'),
        'description' => __('Large background text behind the section title', 'dhaara'),
        'section'     => 'dhaara_about_section',
        'type'        => 'text'
    ));

    // About Title
    $wp_customize->add_setting('about_title', array(
        'default'           => 'Our Creative <span style="color: var(--primary-color)">Approach</span>',
        'sanitize_callback' => 'wp_kses_post',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_title', array(
        'label'       => __('About Title', 'dhaara'),
        'description' => __('You can use HTML tags like <span> for styling', 'dhaara'),
        'section'     => 'dhaara_about_section',
        'type'        => 'textarea'
    ));

    // About Description
    $wp_customize->add_setting('about_description', array(
        'default'           => 'We\'re not just builders – we\'re innovators, dreamers, and problem-solvers pushing the boundaries of architectural possibilities.',
        'sanitize_callback' => 'sanitize_textarea_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_description', array(
        'label'    => __('About Description', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'textarea'
    ));

    // Feature 1
    $wp_customize->add_setting('feature_1_title', array(
        'default'           => 'Innovative Design',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('feature_1_title', array(
        'label'    => __('Feature 1 Title', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('feature_1_desc', array(
        'default'           => 'Pushing architectural boundaries with cutting-edge technology and creative solutions.',
        'sanitize_callback' => 'sanitize_textarea_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('feature_1_desc', array(
        'label'    => __('Feature 1 Description', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'textarea'
    ));

    // Feature 2
    $wp_customize->add_setting('feature_2_title', array(
        'default'           => 'Sustainable Focus',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('feature_2_title', array(
        'label'    => __('Feature 2 Title', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('feature_2_desc', array(
        'default'           => 'Committed to eco-friendly practices and sustainable building solutions.',
        'sanitize_callback' => 'sanitize_textarea_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('feature_2_desc', array(
        'label'    => __('Feature 2 Description', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'textarea'
    ));

    // Feature 3
    $wp_customize->add_setting('feature_3_title', array(
        'default'           => 'Expert Execution',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('feature_3_title', array(
        'label'    => __('Feature 3 Title', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('feature_3_desc', array(
        'default'           => 'Masterful craftsmanship delivered by industry-leading professionals.',
        'sanitize_callback' => 'sanitize_textarea_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('feature_3_desc', array(
        'label'    => __('Feature 3 Description', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'textarea'
    ));

    // About Stats
    $wp_customize->add_setting('about_stat_1_number', array(
        'default'           => '25',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_stat_1_number', array(
        'label'    => __('About Stat 1 Number', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('about_stat_1_text', array(
        'default'           => 'Years of Innovation',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_stat_1_text', array(
        'label'    => __('About Stat 1 Text', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('about_stat_2_number', array(
        'default'           => '500',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_stat_2_number', array(
        'label'    => __('About Stat 2 Number', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('about_stat_2_text', array(
        'default'           => 'Projects Completed',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_stat_2_text', array(
        'label'    => __('About Stat 2 Text', 'dhaara'),
        'section'  => 'dhaara_about_section',
        'type'     => 'text'
    ));

    /**
     * About Images Section
     */
    $wp_customize->add_section('dhaara_about_images', array(
        'title'    => __('About Section Images', 'dhaara'),
        'panel'    => 'dhaara_custom_home',
        'priority' => 70,
    ));

    // About Image 1
    $wp_customize->add_setting('about_image_1', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'about_image_1', array(
        'label'    => __('About Image 1', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'priority' => 10
    )));

    // About Image 1 Title
    $wp_customize->add_setting('about_image_1_title', array(
        'default'           => 'Eco Residences',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_image_1_title', array(
        'label'    => __('About Image 1 Title', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'text',
        'priority' => 11
    ));

    // About Image 1 Description
    $wp_customize->add_setting('about_image_1_desc', array(
        'default'           => 'Modern sustainable living spaces',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_image_1_desc', array(
        'label'    => __('About Image 1 Description', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'text',
        'priority' => 12
    ));

    // About Image 2
    $wp_customize->add_setting('about_image_2', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'about_image_2', array(
        'label'    => __('About Image 2', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'priority' => 20
    )));

    // About Image 2 Title
    $wp_customize->add_setting('about_image_2_title', array(
        'default'           => 'The Azure Tower',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_image_2_title', array(
        'label'    => __('About Image 2 Title', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'text',
        'priority' => 21
    ));

    // About Image 2 Description
    $wp_customize->add_setting('about_image_2_desc', array(
        'default'           => 'A 50-story sustainable skyscraper',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_image_2_desc', array(
        'label'    => __('About Image 2 Description', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'text',
        'priority' => 22
    ));

    // Excellence Box Title
    $wp_customize->add_setting('excellence_title', array(
        'default'           => 'Excellence Recognized',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('excellence_title', array(
        'label'    => __('Excellence Box Title', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'text',
        'priority' => 30
    ));

    // Excellence Box Description
    $wp_customize->add_setting('excellence_desc', array(
        'default'           => 'Multiple international awards for architectural innovation',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('excellence_desc', array(
        'label'    => __('Excellence Box Description', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'textarea',
        'priority' => 31
    ));

    // Excellence Box Icon
    $wp_customize->add_setting('excellence_icon', array(
        'default'           => 'fas fa-star',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('excellence_icon', array(
        'label'       => __('Excellence Box Icon', 'dhaara'),
        'description' => __('Enter FontAwesome icon class (e.g., fas fa-star, fas fa-award, fas fa-trophy)', 'dhaara'),
        'section'     => 'dhaara_about_images',
        'type'        => 'text',
        'priority'    => 32
    ));

    // About Main Image
    $wp_customize->add_setting('about_main_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'about_main_image', array(
        'label'    => __('About Main Featured Image', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'priority' => 40
    )));

    // About Main Image Title
    $wp_customize->add_setting('about_main_title', array(
        'default'           => 'The Horizon Project',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_main_title', array(
        'label'    => __('Main Featured Image Title', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'text',
        'priority' => 41
    ));

    // About Main Image Description
    $wp_customize->add_setting('about_main_desc', array(
        'default'           => 'Award-winning sustainable design',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('about_main_desc', array(
        'label'    => __('Main Featured Image Description', 'dhaara'),
        'section'  => 'dhaara_about_images',
        'type'     => 'text',
        'priority' => 42
    ));

    /**
     * Blog Section
     */
    $wp_customize->add_section('dhaara_blog_section', array(
        'title'    => __('Blog Section', 'dhaara'),
        'panel'    => 'dhaara_custom_home',
        'priority' => 80,
    ));

    // Blog Background Text
    $wp_customize->add_setting('blog_background_text', array(
        'default'           => 'BLOG',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_background_text', array(
        'label'       => __('Blog Background Text', 'dhaara'),
        'description' => __('Large background text behind the section title', 'dhaara'),
        'section'     => 'dhaara_blog_section',
        'type'        => 'text'
    ));

    // Blog Title
    $wp_customize->add_setting('blog_title', array(
        'default'           => 'Latest <span style="color: var(--primary-color)">Insights</span>',
        'sanitize_callback' => 'wp_kses_post',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_title', array(
        'label'       => __('Blog Section Title', 'dhaara'),
        'description' => __('You can use HTML tags like <span> for styling', 'dhaara'),
        'section'     => 'dhaara_blog_section',
        'type'        => 'textarea'
    ));

    // Blog Description
    $wp_customize->add_setting('blog_description', array(
        'default'           => 'Explore our thoughts on architecture, sustainability, and innovation in the built environment.',
        'sanitize_callback' => 'sanitize_textarea_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_description', array(
        'label'    => __('Blog Section Description', 'dhaara'),
        'section'  => 'dhaara_blog_section',
        'type'     => 'textarea'
    ));

    // Number of blog posts to show
    $wp_customize->add_setting('blog_posts_count', array(
        'default'           => 3,
        'sanitize_callback' => 'absint',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control('blog_posts_count', array(
        'label'       => __('Number of Blog Posts to Show', 'dhaara'),
        'description' => __('How many blog posts to display in the home page blog section', 'dhaara'),
        'section'     => 'dhaara_blog_section',
        'type'        => 'number',
        'input_attrs' => array(
            'min' => 1,
            'max' => 12,
            'step' => 1
        )
    ));

    /**
     * Newsletter Section
     */
    $wp_customize->add_section('dhaara_newsletter', array(
        'title'    => __('Newsletter Settings', 'dhaara'),
        'priority' => 33,
    ));

    // Show Newsletter
    $wp_customize->add_setting('show_newsletter', array(
        'default'           => true,
        'sanitize_callback' => 'dhaara_sanitize_checkbox',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control('show_newsletter', array(
        'label'    => __('Show Newsletter Section', 'dhaara'),
        'section'  => 'dhaara_newsletter',
        'type'     => 'checkbox'
    ));

    // Newsletter Title
    $wp_customize->add_setting('newsletter_title', array(
        'default'           => 'Stay Updated',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('newsletter_title', array(
        'label'    => __('Newsletter Title', 'dhaara'),
        'section'  => 'dhaara_newsletter',
        'type'     => 'text'
    ));

    // Newsletter Description
    $wp_customize->add_setting('newsletter_description', array(
        'default'           => 'Join our newsletter for exclusive insights and updates',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('newsletter_description', array(
        'label'    => __('Newsletter Description', 'dhaara'),
        'section'  => 'dhaara_newsletter',
        'type'     => 'text'
    ));

    // Newsletter Form Shortcode
    $wp_customize->add_setting('newsletter_form_shortcode', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control('newsletter_form_shortcode', array(
        'label'       => __('Newsletter Form Shortcode', 'dhaara'),
        'description' => __('Enter the shortcode for your newsletter form plugin (e.g., [newsletter_form], [contact-form-7], etc.)', 'dhaara'),
        'section'     => 'dhaara_newsletter',
        'type'        => 'text',
        'priority'    => 40
    ));

    /**
     * Colors Section
     */
    $wp_customize->add_section('dhaara_colors', array(
        'title'    => __('Theme Colors', 'dhaara'),
        'priority' => 34,
    ));

    // Primary Color
    $wp_customize->add_setting('primary_color', array(
        'default'           => '#FFB600', // Default color
        'sanitize_callback' => 'sanitize_hex_color',
        'transport'         => 'refresh'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'primary_color', array(
        'label'    => __('Primary Color', 'dhaara'),
        'section'  => 'dhaara_colors',
        'priority' => 10
    )));

    // Newsletter Button Background Color
    $wp_customize->add_setting('newsletter_button_bg_color', array(
        'default'           => '#FFB600',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'newsletter_button_bg_color', array(
        'label'    => __('Newsletter Button Background Color', 'dhaara'),
        'section'  => 'dhaara_colors',
        'priority' => 60
    )));

    /**
     * Hero Floating Cards Section
     */
    $wp_customize->add_section('dhaara_hero_cards', array(
        'title'    => __('Hero Floating Cards', 'dhaara'),
        'panel'    => 'dhaara_custom_home',
        'priority' => 45,
    ));

    // Card 1
    $wp_customize->add_setting('hero_card_1_title', array(
        'default'           => 'Quality Assured',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_card_1_title', array(
        'label'    => __('Card 1 Title', 'dhaara'),
        'section'  => 'dhaara_hero_cards',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('hero_card_1_desc', array(
        'default'           => 'Premium materials and expert craftsmanship',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_card_1_desc', array(
        'label'    => __('Card 1 Description', 'dhaara'),
        'section'  => 'dhaara_hero_cards',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('hero_card_1_icon', array(
        'default'           => 'fas fa-check-circle',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_card_1_icon', array(
        'label'       => __('Card 1 Icon', 'dhaara'),
        'description' => __('Enter FontAwesome icon class (e.g., fas fa-check-circle)', 'dhaara'),
        'section'     => 'dhaara_hero_cards',
        'type'        => 'text'
    ));

    // Card 2
    $wp_customize->add_setting('hero_card_2_title', array(
        'default'           => 'Fast Delivery',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_card_2_title', array(
        'label'    => __('Card 2 Title', 'dhaara'),
        'section'  => 'dhaara_hero_cards',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('hero_card_2_desc', array(
        'default'           => 'On-time completion guaranteed',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_card_2_desc', array(
        'label'    => __('Card 2 Description', 'dhaara'),
        'section'  => 'dhaara_hero_cards',
        'type'     => 'text'
    ));

    $wp_customize->add_setting('hero_card_2_icon', array(
        'default'           => 'fas fa-bolt',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('hero_card_2_icon', array(
        'label'       => __('Card 2 Icon', 'dhaara'),
        'description' => __('Enter FontAwesome icon class (e.g., fas fa-bolt)', 'dhaara'),
        'section'     => 'dhaara_hero_cards',
        'type'        => 'text'
    ));

    /**
     * Blog Section Text
     */
    $wp_customize->add_section('dhaara_blog_text', array(
        'title'    => __('Blog Section Text', 'dhaara'),
        'panel'    => 'dhaara_custom_home',
        'priority' => 85,
    ));

    // View All Posts Button Text
    $wp_customize->add_setting('blog_view_all_text', array(
        'default'           => 'View All Posts',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_view_all_text', array(
        'label'    => __('View All Posts Button Text', 'dhaara'),
        'section'  => 'dhaara_blog_text',
        'type'     => 'text'
    ));

    // Learn More Text
    $wp_customize->add_setting('blog_learn_more_text', array(
        'default'           => 'Learn More',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_learn_more_text', array(
        'label'    => __('Learn More Link Text', 'dhaara'),
        'section'  => 'dhaara_blog_text',
        'type'     => 'text'
    ));

    // No Posts Text
    $wp_customize->add_setting('blog_no_posts_text', array(
        'default'           => 'No blog posts found.',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_no_posts_text', array(
        'label'    => __('No Posts Found Text', 'dhaara'),
        'section'  => 'dhaara_blog_text',
        'type'     => 'text'
    ));

    // Reading Time Text
    $wp_customize->add_setting('blog_reading_time_text', array(
        'default'           => 'min read',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_reading_time_text', array(
        'label'    => __('Reading Time Text', 'dhaara'),
        'section'  => 'dhaara_blog_text',
        'type'     => 'text'
    ));

    // No Image Text
    $wp_customize->add_setting('blog_no_image_text', array(
        'default'           => 'No Image',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
    ));

    $wp_customize->add_control('blog_no_image_text', array(
        'label'    => __('No Image Placeholder Text', 'dhaara'),
        'section'  => 'dhaara_blog_text',
        'type'     => 'text'
    ));
}
add_action('customize_register', 'dhaara_customize_register');

/**
 * Sanitization Functions
 */
function dhaara_sanitize_checkbox($checked)
{
    return (isset($checked) && true == $checked) ? true : false;
}

function dhaara_sanitize_social_links($value)
{
    if (empty($value)) {
        return json_encode(array());
    }

    $decoded = json_decode($value, true);
    if (!is_array($decoded)) {
        return json_encode(array());
    }

    foreach ($decoded as &$item) {
        $item['platform'] = sanitize_text_field($item['platform']);
        $item['icon'] = sanitize_text_field($item['icon']);
        $item['url'] = esc_url_raw($item['url']);
    }

    return json_encode($decoded);
}

/**
 * Output Custom Colors CSS
 */
function dhaara_output_custom_colors()
{
    $primary_color = get_theme_mod('primary_color', '#FFB600');

    ?>
    <style type="text/css" id="dhaara-custom-colors">
        :root {
            --primary-color: <?php echo esc_attr($primary_color); ?> !important;
        }
    </style>
<?php
}
add_action('wp_head', 'dhaara_output_custom_colors');

function dhaara_customizer_live_preview()
{
    wp_enqueue_script(
        'dhaara-customizer-preview',
        get_template_directory_uri() . '/inc/js/customizer-preview.js',
        array('customize-preview', 'jquery'),
        '1.0.0',
        true
    );
}
add_action('customize_preview_init', 'dhaara_customizer_live_preview');

/**
 * Update the existing customizer preview script
 */
function dhaara_customizer_live_preview_extended() {
    wp_enqueue_script(
        'dhaara-customizer-preview-extended',
        get_template_directory_uri() . '/inc/js/customizer-preview-extended.js',
        array('customize-preview', 'jquery'),
        '1.0.0',
        true
    );
}
add_action('customize_preview_init', 'dhaara_customizer_live_preview_extended');

 ///////////
/**
 * Add Demo Button Section
 */
function dhaara_add_demo_button() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        // Create the demo section HTML
        var demoSectionHTML = '<li id="accordion-section-dhaara_demo_section" class="accordion-section control-section control-section-dhaara-demo cannot-expand" aria-owns="sub-accordion-section-dhaara_demo_section">' +
            '<h3 class="accordion-section-title">' +
                'Full Elementor Version(Free)' +
                '<a href="https://demo.colorbee.online/dhaara/#demos" class="button button-secondary alignright" target="_blank" style="background: linear-gradient(135deg, #FFB600 0%, #FF8C00 100%); color: white; border: none; font-weight: 600; box-shadow: 0 2px 6px rgba(255, 182, 0, 0.3);display:flex; align-items:center">' +
                    
                    'View' +
                '</a>' +
            '</h3>' +
        '</li>';
        
        // Insert before Site Identity section
        $('#accordion-section-title_tagline').before(demoSectionHTML);
        
        // Add hover effect
        $('#accordion-section-dhaara_demo_section .button').hover(
            function() {
                $(this).css({
                    'transform': 'translateY(-1px)',
                    'box-shadow': '0 3px 10px rgba(255, 182, 0, 0.4)',
                    'background': 'linear-gradient(135deg, #FF8C00 0%, #FFB600 100%)'
                });
            },
            function() {
                $(this).css({
                    'transform': 'translateY(0)',
                    'box-shadow': '0 2px 6px rgba(255, 182, 0, 0.3)',
                    'background': 'linear-gradient(135deg, #FFB600 0%, #FF8C00 100%)'
                });
            }
        );
        
        // Make it non-expandable
        $('#accordion-section-dhaara_demo_section .accordion-section-title').css('cursor', 'default');
        $('#accordion-section-dhaara_demo_section .accordion-section-title').off('click');
    });
    </script>
    
    <style>
        #accordion-section-dhaara_demo_section.cannot-expand .accordion-section-title:after {
            display: none !important;
        }
        #accordion-section-dhaara_demo_section.cannot-expand .accordion-section-title {
            cursor: default !important;
        }
    </style>
    <?php
}

// Add this line to your dhaara_customize_register function:
add_action('customize_controls_print_footer_scripts', 'dhaara_add_demo_button');