<?php
/**
 * dhaara back compat functionality
 *
 * Prevents dhaara from running on WordPress versions prior to 3.9,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 3.9.
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since dhaara 1.0
 */

/**
 * Prevent switching to dhaara on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since dhaara 1.0
 */
function dhaara_switch_theme() {
	switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'dhaara_upgrade_notice' );
}

add_action( 'after_switch_theme', 'dhaara_switch_theme' );

/**
 * Add message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * dhaara on WordPress versions prior to 3.9.
 *
 * @since Twenty Fifteen 1.0
 */
function dhaara_upgrade_notice() {
	$message = sprintf( esc_html__( 'dhaara requires at least WordPress version 3.9. You are running version %s. Please upgrade and try again.', 'dhaara' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevent the Customizer from dhaara loaded on WordPress versions prior to 3.9.
 *
 * @since dhaara 1.0
 */
function dhaara_customize() {
	wp_die( sprintf( esc_html__( 'dhaara requires at least WordPress version 3.9. You are running version %s. Please upgrade and try again.', 'dhaara' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}

add_action( 'load-customize.php', 'dhaara_customize' );

/**
 * Prevent the Theme Preview from dhaara loaded on WordPress versions prior to 3.9.
 *
 * @since dhaara 1.0
 */
function dhaara_customize_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( esc_html__( 'dhaara requires at least WordPress version 3.9. You are running version %s. Please upgrade and try again.', 'dhaara' ), $GLOBALS['wp_version'] ) );
	}
}

add_action( 'template_redirect', 'dhaara_customize_preview' );
