<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package dhaara
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php wp_head(); ?>
    <style>
        <?php
        $preloader_switch = get_theme_mod('preloader_switch', true);
        //Colors
        $primary_color = get_theme_mod('theme_primary_color', primary_color);
        $secondary_color = get_theme_mod('theme_secondary_color', secondary_color);

        ?> :root {
            --primary: <?php echo esc_attr($primary_color); ?>;
            --secondary: <?php echo esc_attr($secondary_color); ?>;

        }
    </style>

</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'dhaara'); ?></a>
    <?php if (!empty($preloader_switch)) : ?>
        <div class="loader-container">
            <div class="square"></div>
            <div class="square"></div>
            <div class="square"></div>
            <div class="background-grid"></div>
            <div class="loading-text"><?php echo esc_html__("Loading...", "dhaara"); ?></div>
        </div>
    <?php endif; ?>
    <!-- Grid Pattern -->
    <div class="bg-pattern-wrapper">
        <div class="bg-pattern-bg background-pattern1"></div>
        <div class="bg-pattern-line background-pattern1"></div>
        <div class="bg-pattern-bg background-pattern2"></div>
        <div class="bg-pattern-line background-pattern2"></div>
        <div class="bg-pattern-bg background-pattern3"></div>
        <div class="bg-pattern-line background-pattern3"></div>
        <div class="bg-pattern-bg background-pattern4"></div>
        <div class="bg-pattern-line background-pattern4"></div>
        <div class="bg-pattern-bg background-pattern5"></div>
        <div class="bg-pattern-line background-pattern5"></div>
    </div>

    <header id="header">
        <div class="">
            <div class="nav-wrapper">
                <div class="nav-bar">
                    <div class="nav-logo">
                    </div>
                    <!-- Top accent line with gradient animation -->
                    <div class="h-1 w-full bg-gradient-to-r from-primary-amber via-primary to-primary-amber bg-[length:200%_100%] animate-[gradient_3s_linear_infinite]"></div>

                    <nav class="py-6 md:px-8 bg-white shadow-sm fade-in  sticky-header1 relative">
                        <div class="container max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                            <div class="flex justify-between items-center">
                                <!-- Logo -->
                                <div class="flex items-center gap-3 scale-in">
                                    <a href="<?php echo esc_url(home_url('/')); ?>" class="flex items-center gap-3 no-underline">
                                        <?php if (has_custom_logo()) : ?>
                                            <?php the_custom_logo(); ?>
                                        <?php else : ?>
                                            <div class="h-12 w-12 bg-primary-amber rounded-lg flex items-center justify-center shadow-lg hover:scale-110 transition-transform">
                                                <span class="text-white text-2xl font-bold uppercase "><?php echo esc_html(substr(get_bloginfo('name'), 0, 1)); ?></span>
                                            </div>
                                            <h1 class="text-gray-900 text-2xl font-light">
                                                <?php echo esc_html(get_bloginfo('name')); ?>
                                            </h1>
                                        <?php endif; ?>
                                    </a>
                                </div>
                                <!-- Desktop Navigation -->
                                <div class=" md:flex items-center gap-12">
                                    <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </button>
                                    <?php
                                    $menu_locations = get_nav_menu_locations(); // Get registered menu locations

                                    if (isset($menu_locations['primary-menu']) && $menu_locations['primary-menu'] != 0) {
                                        // If a menu is assigned to 'primary-menu', display it
                                        wp_nav_menu(array(
                                            'theme_location'  => 'primary-menu',
                                            'menu_class'      => 'menu',
                                            'container'       => 'nav',
                                            'container_class' => 'main-navigation',
                                            'menu_id'         => 'primary-menu',
                                            'fallback_cb' => false,
                                        ));
                                    } else {
                                        // Assign the first available menu dynamically
                                        $available_menus = wp_get_nav_menus(); // Get all menus

                                        if (!empty($available_menus)) {
                                            $first_menu = $available_menus[0]; // Get the first available menu
                                            wp_nav_menu(array(
                                                'menu'           => $first_menu->term_id, // Use the first available menu
                                                'menu_class'     => 'menu',
                                                'container'      => 'nav',
                                                'container_class' => 'main-navigation',
                                                'menu_id'        => 'primary-menu',
                                                'fallback_cb' => false,
                                            ));
                                        } else {
                                            // Fallback: Show a default menu if no menus exist
                                            echo '<nav class="main-navigation"><ul class="menu"><li><a href="' . esc_url(home_url('/')) . '">' . esc_html__('Home', 'dhaara') . '</a></li></ul></nav>';
                                        }
                                    }
                                    ?>


                                </div>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </header>
    <div id="content" class="site-content">

        <?php
        /**
         * Header template with modern design
         */

        $post_id = get_queried_object_id();

        // Get page title based on context
        if (is_front_page() && is_home()) {
            $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'dhaara'));
        } elseif (is_front_page()) {
            $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'dhaara'));
        } elseif (is_home()) {
            if (get_option('page_for_posts')) {
                $title = get_the_title(get_option('page_for_posts'));
            }
        } elseif (is_single() && 'post' == get_post_type()) {
            $title = get_the_title();
        } elseif (is_search()) {
            $title = esc_html__('Search Results for : ', 'dhaara') . get_search_query();
        } elseif (is_404()) {
            $title = esc_html__('Page not Found', 'dhaara');
        } elseif (is_archive()) {
            $title = get_the_archive_title();
        } else {
            $title = get_the_title();
        }

        // Get featured image
        $featured_image = get_the_post_thumbnail_url() ?: get_theme_mod('default_header_image');

        // Initialize default values for Elementor settings
        $page_description = '';
        $show_stats = '';
        $stat_number = '';
        $stat_label = '';
        $stat_icon = '';
        $hide_title = "no";
        $stats_list = array();

        // Only try to get Elementor settings if Elementor is active and the class exists
        if (class_exists('\Elementor\Plugin') && class_exists('\Elementor\Core\Settings\Manager')) {
            try {
                $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers('page');
                if ($page_settings_manager) {
                    $page_settings_model = $page_settings_manager->get_model($post_id);
                    if ($page_settings_model) {
                        $page_description = $page_settings_model->get_settings('page_description');
                        $show_stats = $page_settings_model->get_settings('show_stats');
                        $stat_number = $page_settings_model->get_settings('stat_number');
                        $stat_label = $page_settings_model->get_settings('stat_label');
                        $stat_icon = $page_settings_model->get_settings('stat_icon');
                        $hide_title = $page_settings_model->get_settings('hide_title');
                        $stats_list = [];
                        $settings = $page_settings_model->get_settings();
                        for ($i = 1; $i <= 3; $i++) {
                            if (!empty($settings["stat_label_{$i}"])) {
                                $stats_list[] = [
                                    'stat_icon'   => $settings["stat_icon_{$i}"] ?? null,
                                    'stat_number' => $settings["stat_number_{$i}"] ?? '',
                                    'stat_label'  => $settings["stat_label_{$i}"] ?? '',
                                ];
                            }
                        }
                    }
                }
            } catch (Exception $e) {
                // Silently handle any errors that might occur when accessing Elementor
                error_log('Elementor settings access error: ' . $e->getMessage());
            }
        }

        if (is_front_page()) {
            $hide_title = "yes";
        }

        if (!is_search() && !is_404() && $hide_title != "yes") :
        ?>
            <section class="relative py-16 sm:py-20 overflow-hidden">
                <!-- Background Elements -->
                <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div class="absolute top-1/4 -left-20 w-96 h-96 bg-primary-10 rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
                        <div class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="container max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <div class="flex flex-col lg:flex-row items-center gap-12">
                        <!-- Left Column - Main Content -->
                        <div class="w-full lg:w-1/2 space-y-6">
                            <!-- Breadcrumb -->
                            <nav class="flex items-center space-x-3 text-sm font-medium fade-in-effect ">
                                <a href="<?php echo esc_url(home_url('/')); ?>" class="text-gray-600 hover:text-primary-amber transition-colors">
                                    <?php esc_html_e('Home', 'dhaara'); ?>
                                </a>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                                <span class="text-primary-amber"><?php echo wp_kses_post($title); ?></span>
                            </nav>

                            <!-- Title -->
                            <h1 class="text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect effect-1">
                                <?php echo wp_kses_post($title); ?>
                            </h1>

                            <!-- Description -->
                            <?php if (!empty($page_description)): ?>
                                <p class="text-lg text-gray-600 leading-relaxed fade-in-effect effect-1">
                                    <?php echo wp_kses_post($page_description); ?>
                                </p>
                            <?php endif; ?>

                            <!-- Optional Stats Row -->
                            <?php
                            if ($show_stats === 'yes' && !empty($stats_list) && class_exists('\Elementor\Plugin')): ?>
                                <div class="flex flex-wrap gap-8 pt-6">
                                    <?php
                                    $counter = 1;
                                    foreach ($stats_list as $stat): ?>
                                        <div class="flex items-center gap-4 fade-in-effect effect-<?php echo esc_attr($counter); ?>">
                                            <div class="w-12 h-12 rounded-xl bg-primary-10 flex items-center justify-center">
                                                <?php
                                                if (!empty($stat['stat_icon']) && class_exists('\Elementor\Icons_Manager')) {
                                                    \Elementor\Icons_Manager::render_icon($stat['stat_icon'], [
                                                        'aria-hidden' => 'true',
                                                        'class' => 'w-6 h-6 text-primary-amber'
                                                    ]);
                                                }
                                                ?>
                                            </div>
                                            <div>
                                                <div class="text-2xl font-bold text-gray-900"><?php echo esc_html($stat['stat_number']); ?></div>
                                                <div class="text-sm text-gray-600"><?php echo esc_html($stat['stat_label']); ?></div>
                                            </div>
                                        </div>
                                    <?php
                                        $counter++;
                                    endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Right Column - Featured Image -->
                        <?php if ($featured_image): ?>
                            <div class="lg:w-1/2 relative">
                                <div class="relative group fade-in-effect effect-2">
                                    <!-- Decorative Elements -->
                                    <div class="absolute -inset-4 bg-gradient-to-r from-primary-amber to-white rounded-2xl blur-lg opacity-10 group-hover:opacity-15 transition-opacity "></div>

                                    <!-- Image Container -->
                                    <div class="relative aspect-[4/3] rounded-2xl overflow-hidden  ">
                                        <img src="<?php echo esc_url($featured_image); ?>"
                                            alt="<?php echo esc_attr($title); ?>"
                                            class="w-full h-full object-cover" />
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </section>
        <?php endif; ?>