<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package dhaara
 */


// Get theme options/customizer settings
$company_name = get_theme_mod('company_name', 'Dharā Architecture');
$company_description = get_theme_mod('company_description', 'Crafting innovative spaces that inspire and endure, transforming architectural visions into reality.');
$email = get_theme_mod('contact_email', 'info@example.com');
$phone = get_theme_mod('contact_phone', '+1 (234) 567-890');
?>
</div>
<footer class="relative bg-gray-900 pt-32 overflow-hidden">
    <!-- Decorative Elements -->
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute top-0 left-1/4 w-96 h-96 bg-primary-10 rounded-full mix-blend-overlay filter blur-3xl"></div>
        <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-purple-500/10 rounded-full mix-blend-overlay filter blur-3xl"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full h-56 bg-gradient-to-r from-amber-500/5 via-purple-500/5 to-pink-500/5 rotate-45"></div>
    </div>

    <!-- Newsletter Section -->
    <?php if (get_theme_mod('show_newsletter', true)) : ?>
        <div class="relative max-w-7xl 2xl:max-w-8xl mx-auto px-4 mb-24">
            <div class="bg-gradient-to-r from-primary-amber to-purple-600 rounded-3xl p-12 overflow-hidden">
                <div class="absolute top-0 left-0 w-40 h-40 bg-white/10 rounded-full -translate-x-1/2 -translate-y-1/2"></div>
                <div class="absolute bottom-0 right-0 w-40 h-40 bg-white/10 rounded-full translate-x-1/2 translate-y-1/2"></div>

                <div class="relative flex flex-col md:flex-row items-center justify-between gap-8">
                    <div class="text-center md:text-left">
                        <h3 class="text-3xl font-bold text-white mb-2 footer-newsletter-title"><?php echo esc_html(get_theme_mod('newsletter_title', 'Stay Updated')); ?></h3>
                        <p class="text-amber-100 footer-newsletter-description"><?php echo esc_html(get_theme_mod('newsletter_description', 'Join our newsletter for exclusive insights and updates')); ?></p>
                    </div>
                    <div class="w-full md:w-auto footer-newsletter-form">
                        <?php echo do_shortcode(wp_kses_post(get_theme_mod('newsletter_form_shortcode', ''))); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Footer Content -->
    <div class="relative max-w-7xl 2xl:max-w-8xl mx-auto px-4 pb-12">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-16 footer-links">
            <!-- Brand Section -->
            <div class="space-y-4">
                <div class="flex items-center gap-3">
                    <?php if (has_custom_logo()) : ?>
                        <?php the_custom_logo(); ?>
                    <?php else : ?>
                        <div class="h-12 w-12 bg-white rounded-xl flex items-center justify-center">
                            <span class="text-primary-amber text-2xl font-bold"><?php echo esc_html(substr(get_bloginfo('name'), 0, 1)); ?></span>
                        </div>
                        <h2 class="text-white text-2xl font-light"> <?php echo esc_html(get_bloginfo('name')); ?> </h2>
                    <?php endif; ?>
                </div>
                <p class="text-gray-400 footer-company-description"><?php echo esc_html($company_description); ?></p>

                <!-- Social Media Links -->
                <div class="flex gap-6">
                    <?php
                    $social_links = json_decode(get_theme_mod('social_media_links', '[]'), true);
                    if (!empty($social_links)) :
                        foreach ($social_links as $social) :
                            if (!empty($social['url']) && !empty($social['icon'])) :
                    ?>
                                <a href="<?php echo esc_url($social['url']); ?>"
                                    class="group"
                                    aria-label="<?php echo esc_attr($social['platform']); ?>"
                                    title="<?php echo esc_attr($social['platform']); ?>">
                                    <div class="w-10 h-10 rounded-lg bg-white/5 flex items-center justify-center text-gray-400 group-hover:bg-primary-amber group-hover:text-white transition-all">
                                        <i class="<?php echo esc_attr($social['icon']); ?> w-5 h-5"></i>
                                    </div>
                                </a>
                    <?php
                            endif;
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>

            <!-- Quick Links -->
            <?php if (has_nav_menu('footer-quick-links')) : ?>
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-white"><?php echo esc_html(get_theme_mod('quick_links_title', 'Quick Links')); ?></h3>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-quick-links',
                        'container' => false,
                        'menu_class' => 'space-y-4',
                        'items_wrap' => '%3$s',
                    ));
                    ?>
                </div>
            <?php endif; ?>

            <!-- Services -->
            <?php if (has_nav_menu('footer-services')) : ?>
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-white"><?php echo esc_html(get_theme_mod('services_title', 'Services')); ?></h3>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-services',
                        'container' => false,
                        'menu_class' => 'space-y-4',
                        'items_wrap' => '%3$s',
                    ));
                    ?>
                </div>
            <?php endif; ?>

            <!-- Contact -->
            <div class="space-y-4">
                <h3 class="text-lg font-semibold text-white"><?php echo esc_html(get_theme_mod('contact_title', 'Contact Us')); ?></h3>
                <div class="space-y-4">
                    <?php if ($email) : ?>
                        <a href="mailto:<?php echo esc_attr($email); ?>" class="group flex items-center gap-4 p-4 rounded-xl bg-white/5 hover:bg-white/10 transition-colors border border-white/5 hover:border-white/10 footer-email-link">
                            <div class="w-10 h-10 rounded-lg bg-primary-10 flex items-center justify-center text-white">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div>
                                <div class="text-sm text-gray-400">Email Us</div>
                                <div class="text-white footer-contact-email"><?php echo esc_html($email); ?></div>
                            </div>
                        </a>
                    <?php endif; ?>
                    <?php if ($phone) : ?>
                        <a href="tel:<?php echo esc_attr(preg_replace('/[^0-9+]/', '', $phone)); ?>" class="group flex items-center gap-4 p-4 rounded-xl bg-white/5 hover:bg-white/10 transition-colors border border-white/5 hover:border-white/10 footer-phone-link">
                            <div class="w-10 h-10 rounded-lg bg-primary-10 flex items-center justify-center text-white">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                </svg>
                            </div>
                            <div>
                                <div class="text-sm text-gray-400">Call Us</div>
                                <div class="text-white footer-contact-phone"><?php echo esc_html($phone); ?></div>
                            </div>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Bottom Bar -->
        <div class="mt-16 pt-8 border-t border-white/10">
            <div class="flex flex-col md:flex-row justify-between items-center gap-4">
                <div class="text-gray-400 text-sm">
                    © <?php echo date('Y'); ?> <span class="text-white footer-company-name"><?php echo esc_html($company_name); ?></span>. <?php echo esc_html(get_theme_mod('copyright_text', 'All rights reserved.')); ?>
                </div>
                <?php if (has_nav_menu('footer-bottom')) : ?>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-bottom',
                        'container' => false,
                        'menu_class' => 'flex flex-wrap items-center justify-center gap-8',
                        'link_before' => '<span class="text-gray-400 hover:text-white transition-colors text-sm relative group">',
                        'link_after' => '<span class="absolute -bottom-1 left-0 w-0 h-px bg-amber-400 group-hover:w-full transition-all duration-300"></span></span>',
                        'items_wrap' => '<ul class="%2$s">%3$s</ul>',
                    ));
                    ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</footer>

<?php wp_footer(); ?>
</body>

</html>