'use strict';

// Wait for the page to fully load
window.addEventListener('load', function () {
    'use strict';
    const loader = document.querySelector('.loader-container');

    // Add the hide class to fade out the loader
    loader.classList.add('hide');

    // Remove the loader from the DOM after the transition
    loader.addEventListener('transitionend', function () {
        'use strict';
        loader.remove();
    });
});

document.addEventListener('DOMContentLoaded', function () {
    'use strict';
    const menuToggle = document.querySelector('.menu-toggle');
    const mainNav = document.querySelector('.main-navigation .menu');
    const subMenuParents = document.querySelectorAll('.menu-item-has-children > a');

    // Toggle mobile menu
    if (menuToggle) {
        menuToggle.addEventListener('click', function () {
            'use strict';
            this.classList.toggle('active');
            if (mainNav) {
                mainNav.classList.toggle('active');
            }
        });
    }

    // Handle submenu toggles
    subMenuParents.forEach(item => {
        const arrowElement = item.querySelector('.the-arrow');
        const navLink = item.querySelector('.nav_link');

        // Add click handler for arrow
        if (arrowElement) {
            arrowElement.addEventListener('click', function (e) {
                'use strict';
                if (window.innerWidth <= 768) {
                    e.preventDefault();
                    e.stopPropagation(); // Prevent event bubbling
                    item.classList.toggle('active');
                    const subMenu = item.nextElementSibling;
                    if (subMenu) {
                        subMenu.classList.toggle('active');
                    }
                }
            });
        }

        // Add click handler for nav link
        if (navLink) {
            navLink.addEventListener('click', function (e) {
                'use strict';
                if (window.innerWidth <= 768) {
                    e.stopPropagation(); // Prevent event bubbling
                    // Allow default behavior for navigation
                }
            });
        }

        // Prevent default behavior on parent anchor only if clicking the arrow
        item.addEventListener('click', function (e) {
            'use strict';
            if (window.innerWidth <= 768 && e.target.closest('.the-arrow')) {
                e.preventDefault();
            }
        });
    });

    // Close mobile menu on window resize
    window.addEventListener('resize', function () {
        'use strict';
        if (window.innerWidth > 768) {
            if (menuToggle) {
                menuToggle.classList.remove('active');
            }
            if (mainNav) {
                mainNav.classList.remove('active');
            }
            document.querySelectorAll('.sub-menu.active').forEach(menu => {
                menu.classList.remove('active');
            });
            document.querySelectorAll('.menu-item-has-children > a.active').forEach(item => {
                item.classList.remove('active');
            });
        }
    });
});