<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package dhaara
 */
get_header();
$dhaara_error_title = get_theme_mod('dhaara_error_title', __('Oops! Error 404', 'dhaara'));
$dhaara_error_link_text = get_theme_mod('dhaara_error_link_text', __('Back To Home', 'dhaara'));
$dhaara_error_desc = get_theme_mod('dhaara_error_desc', __('Whoops, this is embarassing. Looks like the page you were looking for was not found.', 'dhaara'));
?>

<div class="content-wrapper">
   <div class="container">
      <section class="dhaara-section error-404 not-found ">
         <div class="error-wrapper content-section">
            <h1 class="error-title"><?php print esc_html($dhaara_error_title); ?></h1>
            <?php if (!empty($dhaara_error_desc)) : ?>
               <div class="error-desc">
                  <p class="text-center"><?php print esc_html($dhaara_error_desc); ?></p>
               </div>
            <?php endif; ?>
            <?php if (!empty($dhaara_error_link_text)) : ?>
               <a href="<?php print esc_url(home_url('/')); ?>" class="dhaara-common-btn">
                  <?php print esc_html($dhaara_error_link_text); ?>
                  <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path d="M16 6.97559L1 6.97559" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                     <path d="M9.95312 0.951L16.0031 6.975L9.95312 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                  </svg>
               </a>
            <?php endif; ?>
         </div>
      </section>
   </div>
</div>
<?php
get_footer();
