<?php
/**
 * Title: Review Card
 * Slug: developry-nexus/review-card
 * Categories: developry-nexus
 * Description: Product/service review with rating and schema markup
 *
 * @package Developry_Nexus
 * @since 1.0.0
 */
?>

<!-- wp:group {"className":"developry-nexus-review-card","style":{"spacing":{"padding":{"top":"var:preset|spacing|large","bottom":"var:preset|spacing|large","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"border":{"radius":"8px"}},"backgroundColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-group developry-nexus-review-card has-base-background-color has-background" style="border-radius:8px;padding-top:var(--wp--preset--spacing--large);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--large);padding-left:var(--wp--preset--spacing--medium)">

	<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between"}} -->
	<div class="wp-block-group">
		<!-- wp:heading {"level":2,"style":{"typography":{"fontWeight":"700"}}} -->
		<h2 class="wp-block-heading" style="font-weight:700"><?php esc_html_e( 'Product/Service Name', 'developry-nexus' ); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"style":{"typography":{"fontSize":"1.5rem","fontWeight":"700"}},"textColor":"primary"} -->
		<p class="has-primary-color has-text-color" style="font-size:1.5rem;font-weight:700"><?php esc_html_e( '⭐ 4.5/5', 'developry-nexus' ); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"style":{"spacing":{"margin":{"top":"var:preset|spacing|small","bottom":"var:preset|spacing|small"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
	<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--small);margin-bottom:var(--wp--preset--spacing--small)">
		<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.875rem"}},"textColor":"secondary"} -->
		<p class="has-secondary-color has-text-color" style="font-size:0.875rem"><?php
			/* translators: %s: Reviewer name */
			printf( esc_html__( 'Reviewed by: %s', 'developry-nexus' ), '<strong>' . esc_html__( 'Your Name', 'developry-nexus' ) . '</strong>' );
		?></p>
		<!-- /wp:paragraph -->

		<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.875rem"}},"textColor":"secondary"} -->
		<p class="has-secondary-color has-text-color" style="font-size:0.875rem"><?php echo esc_html( '•' ); ?></p>
		<!-- /wp:paragraph -->

		<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.875rem"}},"textColor":"secondary"} -->
		<p class="has-secondary-color has-text-color" style="font-size:0.875rem"><?php esc_html_e( 'Date: January 9, 2025', 'developry-nexus' ); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}}}} -->
	<hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--medium);margin-bottom:var(--wp--preset--spacing--medium)"/>
	<!-- /wp:separator -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Review Summary', 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph -->
	<p><?php esc_html_e( 'This is an excellent product/service that delivers on its promises. After extensive testing and use, I can confidently recommend it to others looking for a reliable solution.', 'developry-nexus' ); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Pros', 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:list {"className":"developry-nexus-pros-list"} -->
	<ul class="wp-block-list developry-nexus-pros-list">
		<li><?php esc_html_e( '✅ High quality and well-designed', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( '✅ Easy to use with intuitive interface', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( '✅ Excellent customer support', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( '✅ Good value for the price', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( '✅ Regular updates and improvements', 'developry-nexus' ); ?></li>
	</ul>
	<!-- /wp:list -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Cons', 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:list {"className":"developry-nexus-cons-list"} -->
	<ul class="wp-block-list developry-nexus-cons-list">
		<li><?php esc_html_e( '❌ Could have more advanced features', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( '❌ Slightly expensive for beginners', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( '❌ Learning curve for new users', 'developry-nexus' ); ?></li>
	</ul>
	<!-- /wp:list -->

	<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}}}} -->
	<hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--medium);margin-bottom:var(--wp--preset--spacing--medium)"/>
	<!-- /wp:separator -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Rating Breakdown', 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:group {"layout":{"type":"constrained"}} -->
	<div class="wp-block-group">
		<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph -->
			<p><strong><?php esc_html_e( 'Quality:', 'developry-nexus' ); ?></strong></p>
			<!-- /wp:paragraph -->
			<!-- wp:paragraph -->
			<p><?php esc_html_e( '⭐⭐⭐⭐⭐ 5/5', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph -->
			<p><strong><?php esc_html_e( 'Features:', 'developry-nexus' ); ?></strong></p>
			<!-- /wp:paragraph -->
			<!-- wp:paragraph -->
			<p><?php esc_html_e( '⭐⭐⭐⭐ 4/5', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph -->
			<p><strong><?php esc_html_e( 'Value:', 'developry-nexus' ); ?></strong></p>
			<!-- /wp:paragraph -->
			<!-- wp:paragraph -->
			<p><?php esc_html_e( '⭐⭐⭐⭐ 4/5', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph -->
			<p><strong><?php esc_html_e( 'Support:', 'developry-nexus' ); ?></strong></p>
			<!-- /wp:paragraph -->
			<!-- wp:paragraph -->
			<p><?php esc_html_e( '⭐⭐⭐⭐⭐ 5/5', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->

	<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}}}} -->
	<hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--medium);margin-bottom:var(--wp--preset--spacing--medium)"/>
	<!-- /wp:separator -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Final Verdict', 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph -->
	<p><?php
		/* translators: %s: Highlighted text for "Highly recommended!" */
		printf( esc_html__( 'Overall, this is a solid choice for anyone looking for a reliable solution. Despite a few minor drawbacks, the quality and features make it well worth the investment. %s', 'developry-nexus' ), '<strong>' . esc_html__( 'Highly recommended!', 'developry-nexus' ) . '</strong>' );
	?></p>
	<!-- /wp:paragraph -->

	<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|medium"}}}} -->
	<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--medium)">
		<!-- wp:button {"backgroundColor":"primary"} -->
		<div class="wp-block-button"><a class="wp-block-button__link has-primary-background-color has-background wp-element-button"><?php esc_html_e( 'Check Current Price', 'developry-nexus' ); ?></a></div>
		<!-- /wp:button -->

		<!-- wp:button {"className":"is-style-outline"} -->
		<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Learn More', 'developry-nexus' ); ?></a></div>
		<!-- /wp:button -->
	</div>
	<!-- /wp:buttons -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"0.875rem"},"spacing":{"margin":{"top":"var:preset|spacing|medium"}}},"textColor":"secondary"} -->
	<p class="has-text-align-center has-secondary-color has-text-color" style="margin-top:var(--wp--preset--spacing--medium);font-size:0.875rem"><?php esc_html_e( '💡 To enable Review schema: Go to Customizer → Theme Options → Schema & Structured Data → Enable Review Schema. Add "review" tag or category to this post.', 'developry-nexus' ); ?></p>
	<!-- /wp:paragraph -->

</div>
<!-- /wp:group -->
