<?php
/**
 * Title: Course Information
 * Slug: developry-nexus/course-info
 * Categories: developry-nexus
 * Description: Display course details with schema markup
 *
 * @package Developry_Nexus
 * @since 1.0.0
 */
?>

<!-- wp:group {"className":"developry-nexus-course-info","style":{"spacing":{"padding":{"top":"var:preset|spacing|large","bottom":"var:preset|spacing|large","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}}},"backgroundColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-group developry-nexus-course-info has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--large);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--large);padding-left:var(--wp--preset--spacing--medium)">

	<!-- wp:heading {"level":2,"style":{"typography":{"fontWeight":"700"}}} -->
	<h2 class="wp-block-heading" style="font-weight:700"><?php esc_html_e( 'Course Title', 'developry-nexus' ); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between"}} -->
	<div class="wp-block-group">
		<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph {"style":{"typography":{"fontWeight":"600"}}} -->
			<p style="font-weight:600"><?php esc_html_e( '⏱️ Duration:', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
			<!-- wp:paragraph -->
			<p><?php esc_html_e( '2 hours', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph {"style":{"typography":{"fontWeight":"600"}}} -->
			<p style="font-weight:600"><?php esc_html_e( '📊 Level:', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
			<!-- wp:paragraph -->
			<p><?php esc_html_e( 'Beginner', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph {"style":{"typography":{"fontWeight":"600"}}} -->
			<p style="font-weight:600"><?php esc_html_e( '💰 Price:', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
			<!-- wp:paragraph -->
			<p><?php esc_html_e( '$49.99', 'developry-nexus' ); ?></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->

	<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}}}} -->
	<hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--medium);margin-bottom:var(--wp--preset--spacing--medium)"/>
	<!-- /wp:separator -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Course Description', 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph -->
	<p><?php esc_html_e( 'Learn the fundamentals and advanced techniques in this comprehensive course. This course is designed for beginners who want to build a strong foundation and progress to intermediate level skills.', 'developry-nexus' ); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( "What You'll Learn", 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:list -->
	<ul class="wp-block-list">
		<li><?php esc_html_e( 'Master the core concepts and principles', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( 'Build practical projects from scratch', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( 'Apply best practices and industry standards', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( 'Develop problem-solving skills', 'developry-nexus' ); ?></li>
		<li><?php esc_html_e( 'Gain hands-on experience with real-world scenarios', 'developry-nexus' ); ?></li>
	</ul>
	<!-- /wp:list -->

	<!-- wp:heading {"level":3,"fontSize":"medium"} -->
	<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Instructor', 'developry-nexus' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph -->
	<p><?php
		/* translators: %s: Instructor name and credentials */
		printf( esc_html__( '%s - Expert instructor with 10+ years of experience', 'developry-nexus' ), '<strong>' . esc_html__( 'John Doe', 'developry-nexus' ) . '</strong>' );
	?></p>
	<!-- /wp:paragraph -->

	<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}}}} -->
	<hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--medium);margin-bottom:var(--wp--preset--spacing--medium)"/>
	<!-- /wp:separator -->

	<!-- wp:buttons -->
	<div class="wp-block-buttons">
		<!-- wp:button {"backgroundColor":"primary","width":100} -->
		<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-primary-background-color has-background wp-element-button"><?php esc_html_e( 'Enroll Now', 'developry-nexus' ); ?></a></div>
		<!-- /wp:button -->
	</div>
	<!-- /wp:buttons -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"0.875rem"},"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"textColor":"secondary"} -->
	<p class="has-text-align-center has-secondary-color has-text-color" style="margin-top:var(--wp--preset--spacing--small);font-size:0.875rem"><?php esc_html_e( '💡 To enable Course schema: Go to Customizer → Theme Options → Schema & Structured Data → Enable Course Schema. Add "course" tag or category to this post.', 'developry-nexus' ); ?></p>
	<!-- /wp:paragraph -->

</div>
<!-- /wp:group -->
