<?php
/**
 * Theme & Block Main Functions
 *
 * @package Developry_Nexus
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Theme After Setup Hook
 */
function developry_nexus_setup() {
	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	// Let WordPress manage the document title.
	add_theme_support( 'title-tag' );

	// Enable support for Post Thumbnails on posts and pages.
	add_theme_support( 'post-thumbnails' );

	// Add support for responsive embedded content.
	add_theme_support( 'responsive-embeds' );

	// Add support for editor styles.
	add_theme_support( 'editor-styles' );

	// Add support for HTML5 markup.
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Add support for block styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );

	// Add support for custom line height controls.
	add_theme_support( 'custom-line-height' );

	// Add support for custom units.
	add_theme_support( 'custom-units' );

	// Add support for custom spacing.
	add_theme_support( 'custom-spacing' );

	// Remove core block patterns.
	remove_theme_support( 'core-block-patterns' );

	// Enable Additional CSS in Customizer.
	add_theme_support( 'custom-css' );
}
add_action( 'after_setup_theme', 'developry_nexus_setup' );

/**
 * Enqueue scripts and styles.
 */
function developry_nexus_scripts() {
	// Main stylesheet (already enqueued by WordPress).
	wp_enqueue_style( 'developry-nexus-style', get_stylesheet_uri(), array(), DEVELOPRY_NEXUS_VERSION );

	// Block styles CSS.
	wp_enqueue_style(
		'developry-nexus-block-styles',
		DEVELOPRY_NEXUS_THEME_URI . '/assets/css/block-styles.css',
		array( 'developry-nexus-style' ),
		DEVELOPRY_NEXUS_VERSION
	);

	// Main JavaScript file (async loading for performance).
	wp_enqueue_script(
		'developry-nexus-script',
		DEVELOPRY_NEXUS_THEME_URI . '/assets/js/main.js',
		array(),
		DEVELOPRY_NEXUS_VERSION,
		array(
			'strategy'  => 'defer',
			'in_footer' => true,
		)
	);
}
add_action( 'wp_enqueue_scripts', 'developry_nexus_scripts' );

/**
 * Register block styles
 */
function developry_nexus_register_block_styles() {
	// Button Styles.
	register_block_style(
		'core/button',
		array(
			'name'  => 'developry-nexus-outline',
			'label' => __( 'Outline', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/button',
		array(
			'name'  => 'developry-nexus-ghost',
			'label' => __( 'Ghost', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/button',
		array(
			'name'  => 'developry-nexus-pill',
			'label' => __( 'Pill', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/button',
		array(
			'name'  => 'developry-nexus-shadow',
			'label' => __( 'Shadow', 'developry-nexus' ),
		)
	);

	// Quote Styles.
	register_block_style(
		'core/quote',
		array(
			'name'  => 'developry-nexus-bordered',
			'label' => __( 'Bordered', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/quote',
		array(
			'name'  => 'developry-nexus-highlight',
			'label' => __( 'Highlight', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/quote',
		array(
			'name'  => 'developry-nexus-minimal',
			'label' => __( 'Minimal', 'developry-nexus' ),
		)
	);

	// Image Styles.
	register_block_style(
		'core/image',
		array(
			'name'  => 'developry-nexus-rounded',
			'label' => __( 'Rounded', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/image',
		array(
			'name'  => 'developry-nexus-shadow',
			'label' => __( 'Shadow', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/image',
		array(
			'name'  => 'developry-nexus-bordered',
			'label' => __( 'Bordered', 'developry-nexus' ),
		)
	);

	// List Styles.
	register_block_style(
		'core/list',
		array(
			'name'  => 'developry-nexus-checkmark',
			'label' => __( 'Checkmark', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/list',
		array(
			'name'  => 'developry-nexus-arrow',
			'label' => __( 'Arrow', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/list',
		array(
			'name'  => 'developry-nexus-no-bullets',
			'label' => __( 'No Bullets', 'developry-nexus' ),
		)
	);

	// Heading Styles.
	register_block_style(
		'core/heading',
		array(
			'name'  => 'developry-nexus-underline',
			'label' => __( 'Underline', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/heading',
		array(
			'name'  => 'developry-nexus-gradient',
			'label' => __( 'Gradient Text', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/heading',
		array(
			'name'  => 'developry-nexus-highlight',
			'label' => __( 'Highlight', 'developry-nexus' ),
		)
	);

	// Paragraph Styles.
	register_block_style(
		'core/paragraph',
		array(
			'name'  => 'developry-nexus-dropcap-styled',
			'label' => __( 'Styled Drop Cap', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/paragraph',
		array(
			'name'  => 'developry-nexus-callout',
			'label' => __( 'Callout', 'developry-nexus' ),
		)
	);

	// Group/Container Styles.
	register_block_style(
		'core/group',
		array(
			'name'  => 'developry-nexus-card',
			'label' => __( 'Card', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/group',
		array(
			'name'  => 'developry-nexus-shadow',
			'label' => __( 'Shadow', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/group',
		array(
			'name'  => 'developry-nexus-bordered',
			'label' => __( 'Bordered', 'developry-nexus' ),
		)
	);

	// Separator Styles.
	register_block_style(
		'core/separator',
		array(
			'name'  => 'developry-nexus-dots',
			'label' => __( 'Dots', 'developry-nexus' ),
		)
	);

	register_block_style(
		'core/separator',
		array(
			'name'  => 'developry-nexus-gradient',
			'label' => __( 'Gradient', 'developry-nexus' ),
		)
	);

	// Cover Styles.
	register_block_style(
		'core/cover',
		array(
			'name'  => 'developry-nexus-gradient-overlay',
			'label' => __( 'Gradient Overlay', 'developry-nexus' ),
		)
	);
}
add_action( 'init', 'developry_nexus_register_block_styles' );

/**
 * Register pattern categories
 */
function developry_nexus_register_pattern_categories() {
	register_block_pattern_category(
		'developry-nexus',
		array(
			'label'       => __( 'Nexus', 'developry-nexus' ),
			'description' => __( 'SEO-optimized and AI-ready content patterns with schema markup for better search visibility.', 'developry-nexus' ),
		)
	);
}
add_action( 'init', 'developry_nexus_register_pattern_categories' );
