<?php
/**
 * Theme Setup Functions
 *
 * @package Developry_Nexus
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
function developry_nexus_theme_setup() {
	// Make theme available for translation.
	load_theme_textdomain( 'developry-nexus', DEVELOPRY_NEXUS_THEME_PATH . '/languages' );

	// Register navigation menus.
	register_nav_menus(
		array(
			'primary' => esc_html__( 'Primary Menu', 'developry-nexus' ),
			'footer'  => esc_html__( 'Footer Menu', 'developry-nexus' ),
		)
	);

	// Add support for custom logo.
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 100,
			'width'       => 400,
			'flex-height' => true,
			'flex-width'  => true,
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
}

add_action( 'after_setup_theme', 'developry_nexus_theme_setup' );

/**
 * Register widget areas.
 */
function developry_nexus_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'developry-nexus' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'developry-nexus' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'developry-nexus' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'developry-nexus' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'developry-nexus' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'developry-nexus' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'developry-nexus' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'developry-nexus' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}

add_action( 'widgets_init', 'developry_nexus_widgets_init' );

/**
 * Add custom image sizes.
 */
function developry_nexus_custom_image_sizes() {
	add_image_size( 'developry-nexus-featured', 1200, 675, true ); // 16:9 ratio.
	add_image_size( 'developry-nexus-thumbnail', 400, 300, true );
	add_image_size( 'developry-nexus-square', 600, 600, true );
}

add_action( 'after_setup_theme', 'developry_nexus_custom_image_sizes' );

/**
 * Add custom image size names.
 *
 * @param array $sizes Array of image size labels.
 * @return array Modified array of image size labels.
 */
function developry_nexus_custom_image_size_names( $sizes ) {
	return array_merge(
		$sizes,
		array(
			'developry-nexus-featured'  => esc_html__( 'Featured Image', 'developry-nexus' ),
			'developry-nexus-thumbnail' => esc_html__( 'Thumbnail', 'developry-nexus' ),
			'developry-nexus-square'    => esc_html__( 'Square', 'developry-nexus' ),
		)
	);
}

add_filter( 'image_size_names_choose', 'developry_nexus_custom_image_size_names' );
