<?php
/**
 * Pro Features Configuration
 *
 * Centralized configuration for all Pro features, styles, templates, and patterns.
 * This file ensures consistency across the theme and makes maintenance easier.
 *
 * @package Developry_Nexus
 * @since 1.0.5
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Get list of Pro-only style variations
 *
 * @return array List of Pro style variation names.
 */
function developry_nexus_get_pro_styles() {
	return array(
		'Corporate',
		'Forest',
		'Luxury',
		'Midnight',
		'Monochrome',
		'Nature',
		'Neon',
		'Ocean',
		'Pastel',
		'Sunset',
		'Tech',
		'Vintage',
	);
}

/**
 * Get list of Pro features for Customizer/Admin display
 *
 * @return array Array of feature names with translations.
 */
function developry_nexus_get_pro_features_list() {
	return array(
		__( 'Advanced Content Readability Analysis', 'developry-nexus' ),
		__( 'AI-Powered SEO Recommendations', 'developry-nexus' ),
		__( 'Entity Templates (Person, Product, Place)', 'developry-nexus' ),
		__( 'FAQ & Citation Block Patterns', 'developry-nexus' ),
		__( 'AI Snippet Preview Generator', 'developry-nexus' ),
		__( 'JSON AI Sitemap', 'developry-nexus' ),
		__( 'Content Provenance Tracking', 'developry-nexus' ),
		__( 'Priority Support & Updates', 'developry-nexus' ),
	);
}

/**
 * Get detailed Pro features for upgrade page
 *
 * @return array Array of features with icon, title, and description.
 */
function developry_nexus_get_pro_features_detailed() {
	return array(
		array(
			'icon'        => 'dashicons-chart-line',
			'title'       => __( 'Advanced Readability Analysis', 'developry-nexus' ),
			'description' => __( 'Get detailed insights with multiple readability indices, target audience suggestions, and real-time content improvements.', 'developry-nexus' ),
		),
		array(
			'icon'        => 'dashicons-superhero',
			'title'       => __( 'AI-Powered SEO', 'developry-nexus' ),
			'description' => __( 'Leverage AI to get smart SEO recommendations, keyword suggestions, and content optimization tips.', 'developry-nexus' ),
		),
		array(
			'icon'        => 'dashicons-id',
			'title'       => __( 'Entity Templates', 'developry-nexus' ),
			'description' => __( 'Create rich entity pages for people, products, and places with built-in schema markup.', 'developry-nexus' ),
		),
		array(
			'icon'        => 'dashicons-editor-help',
			'title'       => __( 'FAQ & Citation Blocks', 'developry-nexus' ),
			'description' => __( 'Add structured FAQ sections and citation blocks that enhance SEO and user trust.', 'developry-nexus' ),
		),
		array(
			'icon'        => 'dashicons-visibility',
			'title'       => __( 'AI Snippet Preview', 'developry-nexus' ),
			'description' => __( 'See how AI search engines like Google will display your content in search results.', 'developry-nexus' ),
		),
		array(
			'icon'        => 'dashicons-sos',
			'title'       => __( 'Priority Support', 'developry-nexus' ),
			'description' => __( 'Get fast, expert support from our team when you need help with your site.', 'developry-nexus' ),
		),
	);
}

/**
 * Get list of Pro-only template descriptions
 *
 * @return array Array of template slugs and their descriptions.
 */
function developry_nexus_get_pro_template_descriptions() {
	return array(
		'pro-landing-minimal' => __( 'Clean, distraction-free landing page template optimized for conversions with minimal navigation.', 'developry-nexus' ),
		'pro-full-width'      => __( 'Edge-to-edge full-width template without content constraints, perfect for visual-heavy pages.', 'developry-nexus' ),
		'pro-sidebar-left'    => __( 'Two-column layout with navigation sidebar on the left, great for documentation and blog archives.', 'developry-nexus' ),
		'pro-sidebar-right'   => __( 'Classic blog layout with sidebar on the right for widgets, recent posts, and additional content.', 'developry-nexus' ),
		'pro-portfolio'       => __( 'Showcase your work with a beautiful portfolio layout featuring grid galleries and project details.', 'developry-nexus' ),
		'pro-blog-grid'       => __( 'Modern magazine-style blog template with posts displayed in a responsive card grid layout.', 'developry-nexus' ),
		'pro-contact'         => __( 'Professional contact page template with space for contact forms, maps, and business information.', 'developry-nexus' ),
		'pro-pricing'         => __( 'Dedicated pricing page template designed to showcase your plans and pricing tables effectively.', 'developry-nexus' ),
		'pro-about'           => __( 'Tell your story with an engaging about page layout featuring hero sections and team showcases.', 'developry-nexus' ),
		'pro-testimonials'    => __( 'Build trust with a dedicated testimonials page highlighting customer reviews and success stories.', 'developry-nexus' ),
		'pro-services'        => __( 'Present your services professionally with feature cards, process steps, and call-to-action sections.', 'developry-nexus' ),
		'pro-team'            => __( 'Introduce your team members with a professional layout featuring photos, bios, and social links.', 'developry-nexus' ),
		'pro-faq'             => __( 'Organized FAQ template with accordion-style questions and answers for better user experience.', 'developry-nexus' ),
		'pro-magazine'        => __( 'Editorial-style template with featured content areas, perfect for news sites and content publishers.', 'developry-nexus' ),
		'pro-case-study'      => __( 'In-depth case study template with sections for problems, solutions, and measurable results.', 'developry-nexus' ),
		'pro-documentation'   => __( 'Comprehensive documentation template with table of contents, code blocks, and navigation.', 'developry-nexus' ),
	);
}

/**
 * Get free template descriptions
 *
 * @return array Array of free template slugs and their descriptions.
 */
function developry_nexus_get_free_template_descriptions() {
	return array(
		'blank'         => __( 'A minimal template with no header or footer, perfect for custom page designs and landing pages.', 'developry-nexus' ),
		'page-no-title' => __( 'Standard page template without the page title displayed, ideal for custom headers and hero sections.', 'developry-nexus' ),
	);
}
