<?php
/**
 * Block Editor Sidebar Panel
 *
 * Register a custom sidebar panel in the block editor for post/page settings.
 *
 * @package Developry_Nexus
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue block editor sidebar assets
 */
function developry_nexus_enqueue_editor_sidebar_assets() {
	// Only load in post/page editor, not site editor.
	$screen = get_current_screen();
	if ( ! $screen || 'post' !== $screen->base ) {
		return;
	}

	$asset_file = DEVELOPRY_NEXUS_THEME_PATH . 'assets/js/editor-sidebar.asset.php';
	$asset_data = file_exists( $asset_file ) ? require $asset_file : array(
		'dependencies' => array(
			'wp-plugins',
			'wp-edit-post',
			'wp-element',
			'wp-components',
			'wp-data',
			'wp-compose',
			'wp-i18n',
		),
		'version'      => DEVELOPRY_NEXUS_VERSION,
	);

	wp_enqueue_script(
		'developry-nexus-editor-sidebar',
		DEVELOPRY_NEXUS_THEME_URI . '/assets/js/editor-sidebar.js',
		$asset_data['dependencies'],
		$asset_data['version'],
		true
	);

	wp_enqueue_style(
		'developry-nexus-editor-sidebar',
		DEVELOPRY_NEXUS_THEME_URI . '/assets/css/editor-sidebar.css',
		array( 'wp-edit-post' ),
		DEVELOPRY_NEXUS_VERSION
	);

	// Pass data to JavaScript.
	wp_localize_script(
		'developry-nexus-editor-sidebar',
		'developryNexusEditorSidebar',
		array(
			'isProActive'            => developry_nexus_is_pro_active(),
			'upgradeUrl'             => admin_url( 'themes.php?page=developry-nexus-upgrade-pro' ),
			'showPreview'            => get_theme_mod( 'developry_nexus_summary_show_preview', true ),
			'summaryMaxLength'       => 160,
			'summaryWarning'         => 150,
			'enableReadability'      => get_theme_mod( 'developry_nexus_enable_readability', true ),
			'targetReadabilityScore' => get_theme_mod( 'developry_nexus_target_readability_score', 60 ),
			'minWordCount'           => get_theme_mod( 'developry_nexus_min_word_count', 300 ),
		)
	);
}
add_action( 'enqueue_block_editor_assets', 'developry_nexus_enqueue_editor_sidebar_assets' );

/**
 * Register custom meta fields for the sidebar
 */
function developry_nexus_register_sidebar_meta_fields() {
	// Register Content Provenance meta (Pro feature).
	if ( developry_nexus_is_pro_active() ) {
		register_post_meta(
			'',
			'_developry_nexus_content_provenance',
			array(
				'show_in_rest'  => true,
				'single'        => true,
				'type'          => 'string',
				'auth_callback' => function() {
					return current_user_can( 'edit_posts' );
				},
			)
		);

		register_post_meta(
			'',
			'_developry_nexus_ai_generated',
			array(
				'show_in_rest'  => true,
				'single'        => true,
				'type'          => 'boolean',
				'auth_callback' => function() {
					return current_user_can( 'edit_posts' );
				},
			)
		);
	}
}
add_action( 'init', 'developry_nexus_register_sidebar_meta_fields' );
