<?php
/**
 * Customizer Functions
 *
 * Theme customizer settings and controls organized under Theme Options panel.
 *
 * @package Developry_Nexus
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Register custom upgrade control class
 */
function developry_nexus_register_upgrade_control() {
	/**
	 * Custom Upgrade Control for Pro Features
	 */
	class Developry_Nexus_Upgrade_Control extends WP_Customize_Control {
		/**
		 * Control type
		 *
		 * @var string
		 */
		public $type = 'upgrade';

		/**
		 * Render the control
		 */
		public function render_content() {
			?>
			<div class="developry-nexus-pro-upgrade-notice">
				<div class="developry-nexus-pro-header">
					<span class="dashicons dashicons-star-filled"></span>
					<h3><?php esc_html_e( 'Unlock Premium Features', 'developry-nexus' ); ?></h3>
				</div>

				<div class="developry-nexus-pro-features">
					<h4><?php esc_html_e( 'Nexus Pro Includes:', 'developry-nexus' ); ?></h4>
					<ul>
						<?php foreach ( developry_nexus_get_pro_features_list() as $feature ) : ?>
							<li><span class="dashicons dashicons-yes"></span> <?php echo esc_html( $feature ); ?></li>
						<?php endforeach; ?>
					</ul>
				</div>

				<div class="developry-nexus-pro-cta">
					<a href="<?php echo esc_url( apply_filters( 'developry_nexus_url', 'https://developrythemes.com' ) ); ?>" class="button button-primary button-hero" target="_blank" rel="noopener">
						<?php esc_html_e( 'Upgrade to Pro Now', 'developry-nexus' ); ?>
					</a>
					<p class="developry-nexus-pro-price">
						<?php esc_html_e( 'Starting at $59/year', 'developry-nexus' ); ?>
					</p>
				</div>

				<div class="developry-nexus-pro-footer">
					<p>
						<a href="<?php echo esc_url( apply_filters( 'developry_nexus_url', 'https://developrythemes.com' ) ); ?>" target="_blank" rel="noopener"><?php esc_html_e( 'View All Features', 'developry-nexus' ); ?></a> |
						<a href="<?php echo esc_url( apply_filters( 'developry_nexus_url', 'https://developrythemes.com' ) ); ?>" target="_blank" rel="noopener"><?php esc_html_e( 'Live Demo', 'developry-nexus' ); ?></a>
					</p>
				</div>
			</div>
			<?php
		}
	}
}

add_action( 'customize_register', 'developry_nexus_register_upgrade_control', 1 );

/**
 * Register customizer settings.
 *
 * @param WP_Customize_Manager $wp_customize Customizer object.
 */
function developry_nexus_customize_register( $wp_customize ) {
	// ==========================================
	// MAIN THEME OPTIONS PANEL
	// ==========================================

	$wp_customize->add_panel(
		'developry_nexus_theme_options',
		array(
			'title'       => esc_html__( '🫵 Theme Options', 'developry-nexus' ),
			'description' => esc_html__( 'Configure all Nexus theme settings including SEO, performance, and content features.', 'developry-nexus' ),
			'priority'    => 30,
			'capability'  => 'edit_theme_options',
		)
	);

	// ==========================================
	// 1. GENERAL SETTINGS SECTION
	// ==========================================

	$wp_customize->add_section(
		'developry_nexus_general_section',
		array(
			'title'       => esc_html__( 'General Settings', 'developry-nexus' ),
			'description' => esc_html__( 'Basic theme configuration and site identity.', 'developry-nexus' ),
			'panel'       => 'developry_nexus_theme_options',
			'priority'    => 10,
		)
	);

	// Theme Mode (Light/Dark).
	$wp_customize->add_setting(
		'developry_nexus_theme_mode',
		array(
			'default'           => 'auto',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'developry_nexus_theme_mode',
		array(
			'label'       => esc_html__( 'Color Mode', 'developry-nexus' ),
			'description' => esc_html__( 'Choose light, dark, or auto (follows system preference).', 'developry-nexus' ),
			'section'     => 'developry_nexus_general_section',
			'type'        => 'select',
			'choices'     => array(
				'auto'  => esc_html__( 'Auto (System Preference)', 'developry-nexus' ),
				'light' => esc_html__( 'Light Mode', 'developry-nexus' ),
				'dark'  => esc_html__( 'Dark Mode', 'developry-nexus' ),
			),
		)
	);

	// Enable Breadcrumbs.
	if ( ! developry_nexus_is_pro_active() ) {
		// Show upgrade notice for free users.
		$wp_customize->add_setting(
			'developry_nexus_enable_breadcrumbs_pro',
			array(
				'default'           => '',
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'developry_nexus_enable_breadcrumbs_pro',
			array(
				'label'       => esc_html__( '🔒 Enable Breadcrumbs (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Display breadcrumb navigation on pages and posts. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'developry_nexus_general_section',
				'type'        => 'hidden',
			)
		);
	}

	// ==========================================
	// 3. ACCESSIBILITY SECTION
	// ==========================================

	$wp_customize->add_section(
		'developry_nexus_accessibility_section',
		array(
			'title'       => esc_html__( 'Accessibility', 'developry-nexus' ),
			'description' => esc_html__( 'Configure accessibility features for WCAG compliance.', 'developry-nexus' ),
			'panel'       => 'developry_nexus_theme_options',
			'priority'    => 30,
		)
	);

	// Enable Skip Links.
	$wp_customize->add_setting(
		'developry_nexus_enable_skip_links',
		array(
			'default'           => true,
			'sanitize_callback' => 'wp_validate_boolean',
		)
	);

	$wp_customize->add_control(
		'developry_nexus_enable_skip_links',
		array(
			'label'       => esc_html__( 'Enable Skip Links', 'developry-nexus' ),
			'description' => esc_html__( 'Add "Skip to content" links for keyboard navigation.', 'developry-nexus' ),
			'section'     => 'developry_nexus_accessibility_section',
			'type'        => 'checkbox',
		)
	);

	// ==========================================
	// 4. SEO SCHEMA
	// ==========================================
	$wp_customize->add_section(
		'devry_nexus_seo_section',
		array(
			'title'       => esc_html__( 'SEO & Schema', 'developry-nexus' ),
			'description' => esc_html__( 'Configure SEO features and structured data markup.', 'developry-nexus' ),
			'panel'       => 'developry_nexus_theme_options',
			'priority'    => 40,
		)
	);

	if ( ! developry_nexus_is_pro_active() ) { // Show upgrade notice for free users.
		// Enable Schema Output.
		$wp_customize->add_setting(
			'devry_nexus_enable_schema',
			array(
				'default'           => true,
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'devry_nexus_enable_schema',
			array(
				'label'       => esc_html__( '🔒 Enable Schema Output (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Add JSON-LD structured data to improve search visibility. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'devry_nexus_seo_section',
				'type'        => 'hidden',
			)
		);

		// Enable Article Schema.
		$wp_customize->add_setting(
			'devry_nexus_enable_article_schema',
			array(
				'default'           => true,
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'devry_nexus_enable_article_schema',
			array(
				'label'       => esc_html__( '🔒 Enable Article Schema (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Add Article/BlogPosting schema to posts. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'devry_nexus_seo_section',
				'type'        => 'hidden',
			)
		);

		// Enable Breadcrumb Schema.
		$wp_customize->add_setting(
			'devry_nexus_enable_breadcrumb_schema',
			array(
				'default'           => true,
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'devry_nexus_enable_breadcrumb_schema',
			array(
				'label'       => esc_html__( '🔒 Enable Breadcrumb Schema (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Add BreadcrumbList schema for site navigation. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'devry_nexus_seo_section',
				'type'        => 'hidden',
			)
		);
	}

	// ==========================================
	// 4. PERFORMANCE SECTION
	// ==========================================

	$wp_customize->add_section(
		'developry_nexus_performance_section',
		array(
			'title'       => esc_html__( 'Performance', 'developry-nexus' ),
			'description' => esc_html__( 'Optimize site performance and Core Web Vitals.', 'developry-nexus' ),
			'panel'       => 'developry_nexus_theme_options',
			'priority'    => 40,
		)
	);

	if ( ! developry_nexus_is_pro_active() ) { // Show upgrade notice for free users.
		// Disable Emojis.
		$wp_customize->add_setting(
			'developry_nexus_disable_emojis_pro',
			array(
				'default'           => '',
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'developry_nexus_disable_emojis_pro',
			array(
				'label'       => esc_html__( '🔒 Disable WordPress Emojis (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Improves page load speed by removing emoji scripts. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'developry_nexus_performance_section',
				'type'        => 'hidden',
			)
		);

		// Enable Lazy Loading.
		$wp_customize->add_setting(
			'developry_nexus_enable_lazy_loading_pro',
			array(
				'default'           => '',
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'developry_nexus_enable_lazy_loading_pro',
			array(
				'label'       => esc_html__( '🔒 Enable Lazy Loading (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Defer loading of images below the fold for faster initial page load. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'developry_nexus_performance_section',
				'type'        => 'hidden',
			)
		);

		// Preload Key Resources.
		$wp_customize->add_setting(
			'developry_nexus_preload_resources_pro',
			array(
				'default'           => '',
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'developry_nexus_preload_resources_pro',
			array(
				'label'       => esc_html__( '🔒 Preload Key Resources (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Preload critical CSS and fonts for improved LCP. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'developry_nexus_performance_section',
				'type'        => 'hidden',
			)
		);
	}

	// ==========================================
	// 5. CONTENT READABILITY SECTION
	// ==========================================

	$wp_customize->add_section(
		'developry_nexus_readability_section',
		array(
			'title'       => esc_html__( 'Content Readability', 'developry-nexus' ),
			'description' => esc_html__( 'Configure real-time readability analysis for content creators.', 'developry-nexus' ),
			'panel'       => 'developry_nexus_theme_options',
			'priority'    => 50,
		)
	);

	// Enable Readability Score.
	$wp_customize->add_setting(
		'developry_nexus_enable_readability',
		array(
			'default'           => true,
			'sanitize_callback' => 'wp_validate_boolean',
		)
	);

	$wp_customize->add_control(
		'developry_nexus_enable_readability',
		array(
			'label'       => esc_html__( 'Enable Readability Score', 'developry-nexus' ),
			'description' => esc_html__( 'Show content readability indicators in the post editor.', 'developry-nexus' ),
			'section'     => 'developry_nexus_readability_section',
			'type'        => 'checkbox',
		)
	);

	// Target Readability Score.
	$wp_customize->add_setting(
		'developry_nexus_target_readability_score',
		array(
			'default'           => 60,
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'developry_nexus_target_readability_score',
		array(
			'label'       => esc_html__( 'Target Readability Score', 'developry-nexus' ),
			'description' => esc_html__( 'Set your target Flesch Reading Ease score (0-100). Recommended: 60+ for general audiences.', 'developry-nexus' ),
			'section'     => 'developry_nexus_readability_section',
			'type'        => 'number',
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 1,
			),
		)
	);

	// Show Summary Preview.
	$wp_customize->add_setting(
		'developry_nexus_summary_show_preview',
		array(
			'default'           => true,
			'sanitize_callback' => 'wp_validate_boolean',
		)
	);

	$wp_customize->add_control(
		'developry_nexus_summary_show_preview',
		array(
			'label'       => esc_html__( 'Show Summary Preview', 'developry-nexus' ),
			'description' => esc_html__( 'Display a preview of the post summary in the editor sidebar.', 'developry-nexus' ),
			'section'     => 'developry_nexus_readability_section',
			'type'        => 'checkbox',
		)
	);

	// Minimum Word Count.
	$wp_customize->add_setting(
		'developry_nexus_min_word_count',
		array(
			'default'           => 300,
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'developry_nexus_min_word_count',
		array(
			'label'       => esc_html__( 'Minimum Word Count', 'developry-nexus' ),
			'description' => esc_html__( 'Set minimum word count for content (recommended: 300+ for SEO).', 'developry-nexus' ),
			'section'     => 'developry_nexus_readability_section',
			'type'        => 'number',
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 10000,
				'step' => 50,
			),
		)
	);

	// Advanced Metrics - Pro Feature.
	if ( ! developry_nexus_is_pro_active() ) {
		// Show upgrade notice for free users.
		$wp_customize->add_setting(
			'developry_nexus_advanced_metrics_pro',
			array(
				'default'           => '',
				'sanitize_callback' => '__return_empty_string',
			)
		);

		$wp_customize->add_control(
			'developry_nexus_advanced_metrics_pro',
			array(
				'label'       => esc_html__( '🔒 Advanced Metrics (Pro-only)', 'developry-nexus' ),
				'description' => sprintf(
					/* translators: %s: Upgrade link */
					__( 'Display detailed readability metrics (Flesch Reading Ease, Flesch-Kincaid Grade, etc.) in the editor sidebar. <a href="%s" target="_blank" rel="noopener">Upgrade to Pro →</a>', 'developry-nexus' ),
					'https://developrythemes.com'
				),
				'section'     => 'developry_nexus_readability_section',
				'type'        => 'hidden',
			)
		);
	}

	// Focus Indicators.
	$wp_customize->add_setting(
		'developry_nexus_enhanced_focus',
		array(
			'default'           => true,
			'sanitize_callback' => 'wp_validate_boolean',
		)
	);

	$wp_customize->add_control(
		'developry_nexus_enhanced_focus',
		array(
			'label'       => esc_html__( 'Enhanced Focus Indicators', 'developry-nexus' ),
			'description' => esc_html__( 'Show prominent focus outlines for keyboard navigation.', 'developry-nexus' ),
			'section'     => 'developry_nexus_accessibility_section',
			'type'        => 'checkbox',
		)
	);

	// ==========================================
	// UPGRADE TO PRO PANEL
	// ==========================================
	if ( ! developry_nexus_is_pro_active() ) {
		$wp_customize->add_section(
			'developry_nexus_upgrade_pro',
			array(
				'title'       => esc_html__( '⭐ Upgrade to Pro', 'developry-nexus' ),
				'priority'    => 1,
				'description' => '',
			)
		);

		$wp_customize->add_setting(
			'developry_nexus_upgrade_pro_setting',
			array(
				'default'           => '',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			new Developry_Nexus_Upgrade_Control(
				$wp_customize,
				'developry_nexus_upgrade_pro_setting',
				array(
					'section'  => 'developry_nexus_upgrade_pro',
					'type'     => 'upgrade',
					'priority' => 1,
				)
			)
		);
	}

	// ==========================================
	// PRO-ONLY SECTIONS (Only show when Pro is active)
	// ==========================================

	// Note: The Nexus Pro plugin adds its own customizer sections:
	// - AI Snippet Preview (developry_nexus_pro_ai_preview) - priority 35
	// - SERP Preview (developry_nexus_pro_serp_preview) - priority 36
	// These are automatically registered by the Pro plugin when active.

	// ==========================================
	// REMOVE DEFAULT SECTIONS (Optional)
	// ==========================================

	// You can optionally remove WordPress default sections that are not needed.
	// Uncomment the lines below to remove them:
	// $wp_customize->remove_section( 'colors' );
	// $wp_customize->remove_section( 'background_image' );

}

add_action( 'customize_register', 'developry_nexus_customize_register' );

/**
 * Enqueue customizer preview scripts.
 */
function developry_nexus_customize_preview_js() {
	wp_enqueue_script(
		'developry-nexus-customizer-preview',
		DEVELOPRY_NEXUS_THEME_URI . '/assets/js/customizer-preview.js',
		array( 'customize-preview' ),
		DEVELOPRY_NEXUS_VERSION,
		true
	);
}

add_action( 'customize_preview_init', 'developry_nexus_customize_preview_js' );

/**
 * Add custom styles to the customizer interface.
 */
function developry_nexus_customizer_styles() {
	?>
	<style>
		/* Theme Options Panel Header */
		#accordion-panel-developry_nexus_theme_options > h3 {
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
			color: white !important;
			font-weight: 600;
		}

		#accordion-panel-developry_nexus_theme_options > h3:hover,
		#accordion-panel-developry_nexus_theme_options > h3:focus {
			background: linear-gradient(135deg, #5568d3 0%, #653a8b 100%);
			color: white !important;
		}

		/* Section Headers within Theme Options */
		#accordion-panel-developry_nexus_theme_options .accordion-section-title {
			border-left: 3px solid #667eea;
		}

		/* Active Section */
		#accordion-panel-developry_nexus_theme_options .accordion-section.open .accordion-section-title {
			border-left-color: #764ba2;
		}

		/* Upgrade to Pro Section */
		#accordion-section-developry_nexus_upgrade_pro .accordion-section-title {
			background: linear-gradient(135deg, #ea580c 0%, #f97316 100%) !important;
			color: white !important;
			font-weight: 600;
			border: none !important;
			position: relative;
			animation: pulse 2s infinite;
		}

		#accordion-section-developry_nexus_upgrade_pro .accordion-section-title:hover,
		#accordion-section-developry_nexus_upgrade_pro .accordion-section-title:focus {
			background: linear-gradient(135deg, #ea580c 0%, #f97316 100%) !important;
		}

		@keyframes pulse {
			0%, 100% { box-shadow: 0 0 0 0 rgba(245, 158, 11, 0.4); }
			50% { box-shadow: 0 0 0 10px rgba(245, 158, 11, 0); }
		}

		/* Pro Upgrade Notice Styling */
		.developry-nexus-pro-upgrade-notice {
			background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
			padding: 24px;
			border-radius: 8px;
			color: white;
			margin: 15px 0;
		}

		.developry-nexus-pro-header {
			display: flex;
			align-items: center;
			gap: 10px;
			margin-bottom: 20px;
		}

		.developry-nexus-pro-header .dashicons {
			font-size: 32px;
			width: 32px;
			height: 32px;
			color: #fbbf24;
		}

		.developry-nexus-pro-header h3 {
			margin: 0;
			font-size: 20px;
			color: white;
		}

		.developry-nexus-pro-features {
			background: rgba(255, 255, 255, 0.1);
			padding: 15px;
			border-radius: 6px;
			margin-bottom: 20px;
		}

		.developry-nexus-pro-features h4 {
			margin: 0 0 12px 0;
			color: white;
			font-size: 14px;
			font-weight: 600;
		}

		.developry-nexus-pro-features ul {
			list-style: none;
			margin: 0;
			padding: 0;
		}

		.developry-nexus-pro-features li {
			display: flex;
			align-items: center;
			gap: 8px;
			margin-bottom: 8px;
			font-size: 13px;
			color: rgba(255, 255, 255, 0.95);
		}

		.developry-nexus-pro-features li .dashicons {
			color: #10b981;
			font-size: 18px;
			width: 18px;
			height: 18px;
			flex-shrink: 0;
		}

		.developry-nexus-pro-features li:last-child {
			margin-bottom: 0;
		}

		.developry-nexus-pro-cta {
			text-align: center;
			margin-bottom: 15px;
		}

		.developry-nexus-pro-cta .button-hero {
			background: #fbbf24 !important;
			border-color: #f59e0b !important;
			color: #1f2937 !important;
			font-weight: 600;
			text-shadow: none !important;
			box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1) !important;
			transition: all 0.3s ease !important;
		}

		.developry-nexus-pro-cta .button-hero:hover {
			background: #f59e0b !important;
			transform: translateY(-2px);
			box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15) !important;
		}

		.developry-nexus-pro-price {
			margin: 10px 0 0 0;
			font-size: 12px;
			color: rgba(255, 255, 255, 0.8);
		}

		.developry-nexus-pro-footer {
			text-align: center;
			border-top: 1px solid rgba(255, 255, 255, 0.2);
			padding-top: 15px;
		}

		.developry-nexus-pro-footer p {
			margin: 0;
			font-size: 12px;
		}

		.developry-nexus-pro-footer a {
			color: #fbbf24;
			text-decoration: none;
		}

		.developry-nexus-pro-footer a:hover {
			color: white;
			text-decoration: underline;
		}
	</style>
	<?php
}

add_action( 'customize_controls_print_styles', 'developry_nexus_customizer_styles' );
