<?php
/**
 * Nexus Theme Functions
 *
 * @package Developry_Nexus
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Theme Constants
 */
define( 'DEVELOPRY_NEXUS_VERSION', '1.0.6' );
define( 'DEVELOPRY_NEXUS_THEME_DIR', get_template_directory() );
define( 'DEVELOPRY_NEXUS_THEME_URI', get_template_directory_uri() );
define( 'DEVELOPRY_NEXUS_THEME_PATH', get_template_directory() . '/' );

/**
 * Pro Features Configuration
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/pro-config.php';

/**
 * Core Theme Setup
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/setup.php';

/**
 * Accessibility Enhancements
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/accessibility.php';

/**
 * Schema & SEO Features
 * Note: SEO features have been moved to the Nexus Pro plugin.
 * The free theme focuses on presentation and does not include SEO functionality
 * to comply with WordPress.org theme review guidelines.
 */

/**
 * Customizer Additions
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/customizer.php';

/**
 * Block Editor Sidebar Panel
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/editor-sidebar.php';

/**
 * Theme Mode Switcher
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/theme-mode.php';

/**
 * Content Readability Score
 * Note: This is a Pro feature available in the Nexus Pro plugin.
 * The free theme includes basic readability settings in the Customizer,
 * but full functionality requires the Pro plugin.
 */
if ( file_exists( DEVELOPRY_NEXUS_THEME_PATH . 'inc/readability.php' ) ) {
	require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/readability.php';
}

/**
 * Pro Upgrade CTAs
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/pro-upgrade.php';

/**
 * Pro Features Gating
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/pro-features.php';

/**
 * Admin Functions
 */
if ( is_admin() ) {
	require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/admin.php';
}

/**
 * Theme & Block Functions
 */
require_once DEVELOPRY_NEXUS_THEME_PATH . 'inc/theme.php';
