/**
 * Pro Features Gating
 *
 * Handles hiding Pro-only style variations in the Site Editor
 * when the Pro plugin is not active.
 *
 * @package Developry_Nexus
 * @since 1.0.5
 */

(function () {
	'use strict';

	// Exit if Pro is already active
	if (
		!window.DEVELOPRY_NEXUS_PRO ||
		window.DEVELOPRY_NEXUS_PRO.active
	) {
		return;
	}

	/**
	 * Hide Pro-only style variations from the Site Editor
	 */
	function hideProStyles() {
		const buttons = document.querySelectorAll('[aria-label]');
		buttons.forEach((btn) => {
			const ariaLabel = btn.getAttribute('aria-label');
			if (
				ariaLabel &&
				window.DEVELOPRY_NEXUS_PRO.proStyles.includes(ariaLabel)
			) {
				btn.style.display = 'none';
			}
		});
	}

	// Run on DOM ready
	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', hideProStyles);
	} else {
		hideProStyles();
	}

	// Also run on DOM changes in case new elements are rendered
	const observer = new MutationObserver(hideProStyles);
	observer.observe(document.body, { childList: true, subtree: true });
})();
