/**
 * Customizer Preview Scripts
 *
 * Handles live preview updates in the WordPress Customizer.
 *
 * @format
 * @package Developry_Nexus
 * @since 1.0.0
 */

(function ($) {
	"use strict";

	// Site title and description.
	wp.customize("blogname", function (value) {
		value.bind(function (to) {
			$(".site-title a").text(to);
		});
	});

	wp.customize("blogdescription", function (value) {
		value.bind(function (to) {
			$(".site-description").text(to);
		});
	});

	// Theme Mode (Light/Dark).
	wp.customize("developry_nexus_theme_mode", function (value) {
		value.bind(function (to) {
			const html = $("html");
			html.removeClass("light-mode dark-mode auto-mode");
			html.addClass(to + "-mode");

			// Trigger a custom event for theme mode change
			$(document).trigger("developry-nexus:theme-mode-changed", [to]);
		});
	});

	// Breadcrumbs Toggle.
	wp.customize("developry_nexus_enable_breadcrumbs", function (value) {
		value.bind(function (to) {
			if (to) {
				$(".developry-nexus-breadcrumbs").show();
			} else {
				$(".developry-nexus-breadcrumbs").hide();
			}
		});
	});

	// Performance - Lazy Loading Toggle.
	wp.customize("developry_nexus_enable_lazy_loading", function (value) {
		value.bind(function (to) {
			const images = $("img");
			if (to) {
				images.attr("loading", "lazy");
			} else {
				images.removeAttr("loading");
			}
		});
	});

	// Header text color.
	wp.customize("header_textcolor", function (value) {
		value.bind(function (to) {
			if ("blank" === to) {
				$(".site-title, .site-description").css({
					clip: "rect(1px, 1px, 1px, 1px)",
					position: "absolute"
				});
			} else {
				$(".site-title, .site-description").css({
					clip: "auto",
					position: "relative"
				});
				$(".site-title a, .site-description").css({
					color: to
				});
			}
		});
	});
})(jQuery);
