/**
 * Admin JavaScript
 *
 * Handles admin notice dismissal and other admin-specific functionality.
 *
 * @format
 */

(function ($) {
	"use strict";

	// Wait for DOM to be ready
	$(document).ready(function () {
		// Handle dismissible notices - using document.on to catch dynamically added buttons
		$(document).on("click", ".notice-dismiss", function (e) {
			var $button = $(this);
			var $notice = $button.closest(".notice");

			// Check if this is one of our custom notices
			if (
				!$notice.hasClass("developry-nexus-admin-notice") &&
				!$notice.hasClass("developry-nexus-pro-admin-notice")
			) {
				return; // Not our notice, let WordPress handle it
			}

			var noticeType = $notice.data("notice");

			if (!noticeType) {
				console.warn("No notice type found on:", $notice);
				return;
			}

			// Determine which AJAX action to use based on notice type
			var ajaxAction = "developry_nexus_dismiss_notice";

			if (noticeType === "developry_nexus_pro_notice") {
				ajaxAction = "developry_nexus_dismiss_pro_notice";
			}

			console.log("Dismissing notice:", noticeType, "Action:", ajaxAction);

			// Send AJAX request to dismiss the notice
			$.ajax({
				url: ajaxVars.ajaxUrl,
				type: "POST",
				data: {
					action: ajaxAction,
					nonce: ajaxVars.nonce,
					notice: noticeType
				},
				success: function (response) {
					if (response.success) {
						console.log("Notice dismissed successfully:", noticeType, response.data);
					} else {
						console.error("Failed to dismiss notice:", response);
					}
				},
				error: function (xhr, status, error) {
					console.error("Error dismissing notice:", error, xhr.responseText);
				}
			});
		});
	});
})(jQuery);
