<!-- @format -->

== Developry Nexus ==

Contributors: developry
Theme Name: Developry Nexus
Theme URI: https://developrythemes.com
Tags: full-site-editing, accessibility-ready, custom-colors, custom-menu, custom-logo, editor-style, featured-images, flexible-header, rtl-language-support, sticky-post, threaded-comments, translation-ready, wide-blocks
Version: 1.0.7
Requires at least: 6.0
Requires PHP: 7.4
License: GNU General Public License v2.0 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

A premium WordPress theme engineered for next-generation SEO and AI Search visibility. Built for performance, accessibility, and structured data out of the box.

== Summary ==

The AI-Ready SEO WordPress Theme. Configure your theme settings using the buttons below.

- SEO & Schema - Configure structured data and SEO settings for better search visibility.
- Content Readability - Enable real-time readability analysis for content creators.
- AI & Structured Summary - Configure AI-ready features for better search engine understanding.
- Accessibility - Configure accessibility features for WCAG 2.2 compliance.

== Installation ==

1. In your admin panel, go to 'Appearance > Themes' and click the 'Add New' button.
2. Type in 'Nexus' or 'Developry Nexus' in the search form and press the 'Enter' key.
3. Click on the 'Activate' button to use your new theme right away.
4. Navigate to 'Appearance > Customize' in your admin panel and go to 'Theme Options'.

== Frequently Asked Questions ==

=== Is Nexus Free? ===

Yes, Nexus is a free theme, and always will be.

=== Does Nexus have a Pro version? ===

Yes, it does. Nexus has a Pro available with more custom options.

You can learn more about Nexus Pro [here](https://developrythemes.com).

=== Where can I find documentation? ===

Nexus has extensive documentation you can find [here](https://developrythemes.com).

=== Do you offer support? ===

Definitely, we offer support for the free theme in the [WordPress.org forums](https://wordpress.org/support/theme/developry-nexus).

=== Where can I find the theme options? ===

All of our options can be found in the Customizer in 'Appearance > Customize > Theme Options'.

== Support ==

This theme is provided as is for FREE of use and additional support isn't provided yet. I will add fixes and updates in the future but user requests and modifications won't be accepted.

However, if you are interested please visit our website https://developrythemes.com where you will find an extended Pro version of the theme as well as FSE theme with many more features that will include extended support and regular updates.

== Credits ==

I'd like to give credit where credit is due.

Below is that list with links to all the scripts, media and software that was used to create the Nexus WordPress theme.

=== WordPress ===

The best content management system.

URL: https://wordpress.org/
License: GPLv2
License URI: https://www.gnu.org/licenses/gpl-2.0.html

== Copyright ==

Copyright (c) 2018-2025 Developry https://developry.com/

GNU GENERAL PUBLIC LICENSE Version 2, June 1991 - https://github.com/systemd/systemd/blob/master/LICENSE.GPL2

== Changelog ==

=== 1.0.0 ===

- Initial stable version submitted to the WordPress.org repository.

=== 1.0.1 ===

- Change theme URL to https://developrythemes.com/.
- Fix the admin notice dismissible buttons when clicked to remembere and not show them anymore.
- Change the theme screenshot to accurately reflect the default look of the theme when it is first activated.
- Make all the text strings in the PHP file should be translation-ready.
- Remove images theme files and should not be loaded from external URLs.
- Update tested up to in the style.css file to the latest WordPress version.
- Remove the SEO-related functionality.
- Remove the blank folders.

=== 1.0.2 ===

- Added developry_nexus_summary_show_preview customizer setting in Content Readability section to control summary preview display in the editor sidebar
- Fixed missing get_theme_mod() calls for developry_nexus_enable_readability, developry_nexus_target_readability_score, and developry_nexus_min_word_count in editor sidebar
- Fixed unregistered developry_nexus_summary_show_preview setting that was being used without registration
- Updated editor sidebar JavaScript localization to pass all readability-related customizer settings (enableReadability, targetReadabilityScore, minWordCount) to the block editor
- Updated customizer.php to register the missing developry_nexus_summary_show_preview checkbox control in the Content Readability section

=== 1.0.3 ===

- Fixed the 'developry_nexus' text domain to 'developry-nexus'

=== 1.0.4 ===

- Made all hardcoded text strings translation-ready in inc/pro-features.php
- Made all hardcoded text strings translation-ready in patterns/hero-with-image.php
- Replaced data URI image with locally hosted SVG file in assets/img/hero-placeholder.svg
- Updated hero-with-image.php pattern to use get_template_directory_uri() for local image reference
- Made image alt text translation-ready using esc_attr_e()

=== 1.0.5 ===

- Made all hardcoded text strings translation-ready in patterns/hero-centered.php
- Made all hardcoded text strings translation-ready in patterns/features-grid.php
- Made all hardcoded text strings translation-ready in patterns/cta-section.php
- Made all hardcoded text strings translation-ready in patterns/course-info.php
- Made all hardcoded text strings translation-ready in patterns/review-card.php
- All pattern files now use proper WordPress escaping functions (esc_html_e, esc_html\_\_, printf) with 'developry-nexus' text domain

=== 1.0.6 ===

**Critical Bug Fixes:**

- Fixed critical bug: Uncommented essential action hooks in inc/setup.php that prevented theme setup and widget registration
- Theme setup function (developry_nexus_theme_setup) now properly registers navigation menus and custom logo support
- Widget areas (Sidebar, Footer 1-3) now properly register and display

**Code Architecture Improvements:**

- Created new centralized configuration file (inc/pro-config.php) for all Pro features, styles, templates, and patterns
- Added helper functions: developry_nexus_get_pro_styles(), developry_nexus_get_pro_features_list(), developry_nexus_get_pro_features_detailed(), developry_nexus_get_pro_template_descriptions()
- Refactored inline JavaScript to separate file (assets/js/pro-features.js) following WordPress best practices
- Implemented wp_localize_script() instead of wp_add_inline_script() for better performance and maintainability
- Eliminated code duplication across customizer.php, pro-upgrade.php, and pro-features.php

**Code Cleanup:**

- Removed unused placeholder file (assets/js/editor.js) that had no functionality
- Removed debug console.log statements from main.js for cleaner production code
- Updated DEVELOPRY_NEXUS_VERSION constant from 1.0.0 to match actual version 1.0.6

**Security & WordPress Coding Standards:**

- Verified all AJAX handlers use check_ajax_referer() with proper nonces
- Confirmed all user input is properly sanitized with sanitize_text_field() and wp_unslash()
- Verified all output is properly escaped with esc_html(), esc_attr(), esc_url()
- Ensured capability checks are in place for all admin functions
- Confirmed no SQL injection vulnerabilities (theme uses WordPress APIs exclusively)
- Verified XSS prevention through proper escaping throughout the theme

**Maintainability:**

- Centralized Pro features configuration makes future updates easier and reduces maintenance overhead
- Proper script dependencies and defer loading strategy improve performance
- Cleaner, more organized codebase following WordPress Coding Standards (WPCS)

=== 1.0.7 ===

- Rebuild and regenrate the languages/ theme file
- Update and add a better screenshot for the theme preview
