<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

?>
	<section id="cover" class="cover">
		<div class="cover-img">
			<?php if ( has_post_thumbnail() ) : ?>
				<img src="<?php echo esc_url( get_the_post_thumbnail_url() ); ?>" alt="" />
			<?php else : ?>
				<img src="<?php echo esc_url( get_header_image() ); ?>" alt="" />
			<?php endif; ?>
		</div>
		<?php if ( is_page_template( 'templates/fullwidth.php' ) || is_front_page() ) : ?>
			<div class="cover-body">
				<h1><?php the_title(); ?></h1>
				<?php echo esc_html( the_excerpt() ); ?>
			</div>
			<a href="#scrolldown" class="scrollbody">
				<i class="dashicons dashicons-arrow-down-alt2"></i>
			</a>
		<?php endif; ?>
		<div class="cover-overlay"></div>
	</section>
