<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

$theme_options = (array) json_decode( DEVELOPRY_LITE_THEME_OPTIONS );

?>
	<nav id="navbar" class="navbar navbar-expand-lg px-3 <?php echo $theme_options['navbar_text_color']; ?> <?php echo $theme_options['navbar_background_color']; ?>">
		<div class="container-fluid">
			<?php if ( function_exists( 'the_custom_logo' ) && the_custom_logo() ) : ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'description' ); ?>" class="navbar-brand site-title">
					<?php the_custom_logo(); ?>
				</a>
			<?php elseif ( true === display_header_text() ) : ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'description' ); ?>" class="navbar-brand site-title">
					<?php bloginfo( 'name' ); ?>
				</a>
			<?php endif; ?>
			<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-collapse" aria-controls="navbar-collapse" aria-expanded="false" aria-label="toggle navigation">
				<i class="dashicons dashicons-menu"></i>
			</button>
			<div id="navbar-collapse" class="navbar-collapse collapse d-xl-flex d-lg-flex <?php echo ( 'd-none' === $theme_options['search_form'] ) ? 'justify-content-end' : 'justify-content-space-between'; ?>">
				<?php
					get_template_part( 'template-parts/header/main-menu' );
					get_template_part( 'template-parts/header/search-form' );
				?>
			</div>
		</div>
	</nav>
