<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

?>
	<section>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="footer-copyright">
						<?php if ( is_active_sidebar( 'copyright-1' ) ) : ?>
							<div class="row">
								<div class="col-12 col-lg-6">
									<div class="text-lg-left text-md-left text-sm-center text-center">
										<?php dynamic_sidebar( 'copyright-1' ); ?>
									</div>
								</div>

								<div class="col-12 col-lg-6">
									<p class="text-lg-right text-md-right text-sm-center text-center">
										<?php echo esc_html__( 'Proudly powered by', 'developry-lite' ); ?>
										<a href="https://wordpress.org">
											<?php echo esc_html__( 'WordPress', 'developry-lite' ); ?>
										</a>

										<br />

										<?php echo esc_html__( 'Build and customized with ', 'developry-lite' ); ?>
										<a href="<?php echo esc_url( DEVELOPRY_LITE_SITE_URL ); ?>" title="Custom WordPress Theme and Plugin Development">
											<?php echo esc_html__( 'Developry Lite', 'developry-lite' ); ?>
										</a>
									</p>
								</div>
							</div>
						<?php else : ?>
							<p class="text-center">
								&copy; <?php echo esc_html( gmdate( 'Y' ) ); ?> 
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-title">
									<?php bloginfo( 'name' ); ?>
								</a>. 
								<?php echo esc_html__( 'All rights reserved.', 'developry-lite' ); ?>

								<br /><br />

								<?php echo esc_html__( 'Proudly powered by', 'developry-lite' ); ?> 
								<a href="https://wordpress.org">
									<?php echo esc_html__( 'WordPress', 'developry-lite' ); ?>
								</a>

								<br />

								<?php echo esc_html__( 'Build and customized with', 'developry-lite' ); ?> 
								<a href="<?php echo esc_url( DEVELOPRY_LITE_SITE_URL ); ?>" title="Custom WordPress Theme and Plugin Development">
									<?php echo esc_html__( 'Developry Lite', 'developry-lite' ); ?>
								</a>
							</p>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
