<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

$theme_options = (array) json_decode( DEVELOPRY_LITE_THEME_OPTIONS );

?>
<?php if ( have_posts() ) : ?>
	<?php while ( have_posts() ) : ?>
		<?php the_post(); ?>
		<article id="post-<?php the_ID(); ?>" class="content <?php echo esc_html( implode( ' ', get_post_class() ) ); ?>">
			<h2 class="article-title">
				<a href="<?php the_permalink(); ?>">
					<?php the_title(); ?>
				</a>
				<br />
				<span class="lead">
					in <?php the_category( ', ' ); ?>
				</span>
			</h2>

			<?php if ( has_post_thumbnail() ) : ?>
				<p>
					<a href="<?php the_permalink(); ?>">
						<img src="<?php echo esc_url( get_the_post_thumbnail_url() ); ?>" alt="" class="img-fluid d-block" />
					</a>
				</p>
			<?php endif; ?>

			<p class="lead">
				<?php if ( '' !== get_the_excerpt() ) : ?>
					<?php echo esc_html( get_the_excerpt() ); ?>
					<br />
				<?php endif; ?>
				<a href="<?php the_permalink(); ?>" class="mt-3 d-block">
					<?php echo esc_html__( 'Continue reading', 'developry-lite' ); ?>
				</a>
			</p>

			<?php
				// Uncomment this line and remove the class='lead' above if you need full content showing in the Blog.
				// the_content();
			?>
			<?php
				get_template_part( 'template-parts/content/content', 'aside' );
			?>
		</article>
	<?php endwhile; ?>
<?php endif; ?>
