<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

$prev            = get_previous_post( false, '', 'category' );
$post_title_next = esc_html( @get_the_title( $prev->ID ) );
$post_page_next  = '<i class="dashicons dashicons-arrow-left-alt2"></i> &nbsp; ' . esc_html__( 'Newer Posts', 'developry-lite' );

$next            = get_next_post( false, '', 'category' );
$post_title_prev = esc_html( @get_the_title( $next->ID ) );
$post_page_prev  = esc_html__( 'Older Posts', 'developry-lite' ) . ' &nbsp; <i class="dashicons dashicons-arrow-right-alt2"></i>';
?>
<footer class="content-navigtion">
	<?php if ( is_single() ) : ?>
		<nav class="pagination">
			<?php if ( is_a( $prev, 'WP_Post' ) ) : ?>
				<a href="<?php echo esc_url( get_permalink( $prev->ID ) ); ?>" class="previous-link">
					<i class="dashicons dashicons-arrow-left-alt2"></i>
					<?php echo ( ! empty( $post_title_prev ) ) ? esc_html( get_the_title( $prev->ID ) ) : esc_html__( 'Previous Post', 'developry-lite' ); ?>
				</a>
			<?php endif; ?>

			<?php if ( is_a( $next, 'WP_Post' ) ) : ?>
				<a href="<?php echo esc_url( get_permalink( $next->ID ) ); ?>" class="next-link">
					<?php echo ( ! empty( $post_title_next ) ) ? esc_html( get_the_title( $next->ID ) ) : esc_html__( 'Next Post', 'developry-lite' ); ?>
					<i class="dashicons dashicons-arrow-right-alt2"></i>
				</a>
			<?php endif; ?>
		</nav>
	<?php else : ?>
		<nav class="pagination">
			<?php posts_nav_link( ' ', $post_page_next, $post_page_prev ); ?>
		</nav>
	<?php endif; ?>
</footer>
