<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

$meta          = wp_get_attachment_metadata();
$theme_options = (array) json_decode( DEVELOPRY_LITE_THEME_OPTIONS );

?>
<?php if ( have_posts() ) : ?>
	<?php while ( have_posts() ) : ?>
		<?php the_post(); ?>
		<?php if ( ! empty( $meta['file'] ) ) : ?>
			<?php if ( ! empty( $post->post_excerpt ) ) : ?>
				<?php the_excerpt(); ?>
			<?php endif; ?>

			<p>
				<a href="<?php echo esc_url( wp_get_attachment_url() ); ?>" title="<?php the_title_attribute(); ?>" rel="attachment">
					<img src="<?php echo esc_url( wp_get_attachment_url( get_the_ID() ) ); ?>" alt="" class="img-fluid d-block" />
				</a>
			</p>

			<?php
				get_template_part( 'template-parts/content/content', 'aside' );
				get_template_part( 'template-parts/content/content', 'comments' );
			?>
		<?php endif; ?>
		<!-- TODO : show empty page if attachment media isn't an image (e.g. audio or video) -->
	<?php endwhile; ?>
<?php endif; ?>
