<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

$post_type = get_post_type();

?>
	<aside class="content-aside">
		<!-- gravatar -->
		<img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ) ) ); ?>" alt="" class="" />

		<p>
			<?php if ( 'attachment' === $post_type ) : ?>
				<?php echo esc_html__( 'This attachment was uploaded by', 'developry-lite' ); ?>
			<?php else : ?>
				<?php echo esc_html__( 'This post was published by', 'developry-lite' ); ?>
			<?php endif; ?>

			<!-- author -->
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>">
				<?php echo esc_html( get_the_author_meta( 'display_name', get_the_author_meta( 'ID' ) ) ); ?>
			</a>

			<!-- date -->
			<?php echo esc_html__( 'on', 'developry-lite' ); ?>
			<a href="<?php echo esc_url( home_url( '/' ) ) . esc_html( get_the_time( 'Y/m ' ) ); ?>">
				<?php the_time( 'F j, Y' ); ?>
			</a>

			<!-- time -->
			<?php echo esc_html__( 'at', 'developry-lite' ); ?>
			<?php the_time( 'h:m a' ); ?>
			<br />

			<?php if ( 'attachment' !== $post_type ) : ?>
					<!-- categories -->
					<?php echo esc_html__( 'Posted in', 'developry-lite' ); ?>
					<?php the_category( ', ' ); ?>

					<!-- tags -->
					<?php $tags = get_the_tags(); ?>
					<?php if ( ! empty( $tags ) ) : ?>
							<?php echo esc_html__( ' and tagged with', 'developry-lite' ); ?>
							<?php the_tags( '', ', ' ); ?>
					<?php endif; ?>
					<br />
			<?php endif; ?>

			<!-- comments -->
			<?php echo esc_html__( 'Currently it has posted ', 'developry-lite' ); ?>
			<a href="<?php the_permalink(); ?>#comments">
					<?php
					comments_number(
						esc_html__( '0 comments', 'developry-lite' ),
						esc_html__( '1 comment', 'developry-lite' ),
						esc_html__( '% comments', 'developry-lite' )
					);
					?>
			</a>
			<?php
			edit_post_link(
				esc_html__( 'Edit...', 'developry-lite' ),
				'<button type="button" class="btn btn-sm btn-outline-primary bg-light text-dark post-edit-link"><i class="dashicons dashicons-edit"></i> ',
				'</button>'
			);
			?>
		</p>
	</aside>
