<?php
/**
 * Add basic WP theme support components; customize exceprts.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'add_theme_support' ) ) {
	return;
}

/**
 * Load all theme support features
 */
function load_theme_support() {
	// Theme editor styles based on the user selecton from the WP Customizer.
	$theme_options = (array) json_decode( DEVELOPRY_LITE_THEME_OPTIONS );

	// Laoding theme text domain for translation.
	load_theme_textdomain( 'developry-lite' );

	// Theme default content width.
	if ( ! isset( $content_width ) ) {
		$content_width = 800;
	}

	// Add support for editor styles.
	add_theme_support( 'editor-styles' );

	if ( ! empty( $theme_options['bootswatch_theme'] ) ) {
		add_editor_style( './assets/dist/css/themes/' . $theme_options['bootswatch_theme'] . '.min.css' );
	} else {
		add_editor_style( './assets/dist/css/themes/zephyr.min.css' );
	}

	// Theme additional admin area styles.
	add_editor_style( './assets/dist/css/admin.min.css' );

	// Widget sidebars can use selective refresh in the Customizer.
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	// Let WordPress manage the document title.
	add_theme_support( 'title-tag' );

	// Enable support for custom logo.
	add_theme_support(
		'custom-logo',
		array(
			'width'       => 150,
			'height'      => 45,
			'flex-width'  => true,
			'flex-height' => true,
			'header-text' => array( 'site-title', 'site-description' ),
		)
	);

	// Enable support for custom headers with default one loaded.
	add_theme_support(
		'custom-header',
		array(
			'default-color' => '',
			'default-image' => DEVELOPRY_LITE_THEME_URI . '/assets/dist/img/page-cover.jpg',
			'width'         => 1280,
			'height'        => 960,
			'uploads'       => true,
			'flex-width'    => true,
			'flex-heigt'    => true,
		)
	);

	// Add default posts and comments RSS feed links to head.
	add_theme_support(
		'custom-background',
		array( 'default-color' => '' )
	);

	// Enable support for Excerpts on pages.
	add_post_type_support( 'page', 'excerpt' );

	// Enable support for Post Thumbnails on posts and pages.
	add_theme_support(
		'post-thumbnails',
		array( 'post', 'page' )
	);

	set_post_thumbnail_size( 1280, 960, true );

	// Switch default core markup for search form, comment form, and comments.
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		)
	);

	// Enable support for full with and align wide for block editor.
	add_theme_support( 'align-wide' );

	// Enable support responsive youtube and other emebds.
	add_theme_support( 'responsive-embeds' );

	// Enable support for block editor styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for custom line height controls.
	add_theme_support( 'custom-line-height' );

	// Add support for link color control.
	add_theme_support( 'link-color' );

	// Add support for experimental cover block spacing.
	add_theme_support( 'custom-spacing' );

	// Add support for custom units.
	add_theme_support( 'custom-units' );

	// Add custom editor font sizes.
	add_theme_support(
		'editor-font-sizes',
		array(
			array(
				'name'      => esc_html__( 'Extra small', 'developry-lite' ),
				'shortName' => esc_html_x( 'XS', 'Font size', 'developry-lite' ),
				'size'      => 16,
				'slug'      => 'extra-small',
			),
			array(
				'name'      => esc_html__( 'Small', 'developry-lite' ),
				'shortName' => esc_html_x( 'S', 'Font size', 'developry-lite' ),
				'size'      => 18,
				'slug'      => 'small',
			),
			array(
				'name'      => esc_html__( 'Normal', 'developry-lite' ),
				'shortName' => esc_html_x( 'M', 'Font size', 'developry-lite' ),
				'size'      => 20,
				'slug'      => 'normal',
			),
			array(
				'name'      => esc_html__( 'Large', 'developry-lite' ),
				'shortName' => esc_html_x( 'L', 'Font size', 'developry-lite' ),
				'size'      => 24,
				'slug'      => 'large',
			),
			array(
				'name'      => esc_html__( 'Extra large', 'developry-lite' ),
				'shortName' => esc_html_x( 'XL', 'Font size', 'developry-lite' ),
				'size'      => 40,
				'slug'      => 'extra-large',
			),
			array(
				'name'      => esc_html__( 'Huge', 'developry-lite' ),
				'shortName' => esc_html_x( 'XXL', 'Font size', 'developry-lite' ),
				'size'      => 96,
				'slug'      => 'huge',
			),
			array(
				'name'      => esc_html__( 'Gigantic', 'developry-lite' ),
				'shortName' => esc_html_x( 'XXXL', 'Font size', 'developry-lite' ),
				'size'      => 144,
				'slug'      => 'gigantic',
			),
		)
	);
}

add_action( 'after_setup_theme', __NAMESPACE__ . '\load_theme_support' );

/**
 * Change the default post/page exceprt length
 */
function set_excerpt_length( $length ) {
	if ( is_admin() ) {
		return $length;
	}

	return 55;
}

add_action( 'excerpt_length', __NAMESPACE__ . '\set_excerpt_length', 999 );


/**
 * Remove the [...] from excerpts, there's Continue reading... link added manually.
 */
function remove_excerpt_more( $more ) {
	if ( is_admin() ) {
		return $more;
	}

	return '';
}

add_action( 'excerpt_more', __NAMESPACE__ . '\remove_excerpt_more' );
