<?php
/**
 * Add theme support for starter content for freshly installed WP.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attacha and populate starter pages, posts, images, widgets etc. with some default content
 */
function add_theme_starter_content() {
	$lorem_ipsum = '<div class="features">
			<div class="row text-center">
				<div class="col-12 col-lg-4">
					<i class="dashicons dashicons-clock text-primary display-2"></i>
					<h3 class="pb-4 fw-bolder">Build Quickly</h3>
					<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec.</p>
				</div>
				<div class="col-12 col-lg-4">
					<i class="dashicons dashicons-admin-appearance text-primary display-2"></i>
					<h3 class="pb-4 fw-bolder">25+ Starter Themes</h3>
					<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec.</p>
				</div>
				<div class="col-12 col-lg-4">
					<i class="dashicons dashicons-admin-generic text-primary display-2"></i>
					<h3 class="pb-4 fw-bolder">Easy to Customize</h3>
					<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec.</p>
				</div>
			</div>
		</div>
		<div class="sections">
			<div class="bg-white p-5 pb-4 rounded-3 mb-5">
				<div class="row align-items-center">
					<div class="col-12 col-lg-6">
						<div class="display-6 fw-bold">No coding required</div>
						<p class="lead my-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>
						<a class="btn btn-primary btn-sm px-4 py-2 mb-4" href="#">LEARN MORE</a>
					</div>
					<div class="col-12 col-lg-6">
						<img src="/wp-content/themes/developry-lite/assets/dist/img/content-42.jpg" alt="" class="img-fluid w-100" />
					</div>
				</div>
			</div>
			<div class="bg-light p-5 pb-4 rounded-3 mb-5">
				<div class="row align-items-center">
					<div class="col-12 col-lg-6 order-1 order-lg-1 order-md-2 order-sm-2">
						<img src="/wp-content/themes/developry-lite/assets/dist/img/content-48.jpg" alt="" class="img-fluid w-100" />
					</div>
					<div class="col-12 col-lg-6 order-2 order-lg-2 order-md-1 order-sm-1">
						<div class="display-6 fw-bold">Numerous styles and variations</div>
						<p class="lead my-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>
						<a class="btn btn-primary btn-sm px-4 py-2 mb-4" href="#">LEARN MORE</a>
					</div>
				</div>
			</div>
			<div class="bg-dark text-white p-5 pb-4 rounded-3 mb-5">
				<div class="row align-items-center">
					<div class="col-12 col-lg-6">
						<div class="display-6 fw-bold">Intuititve and easy to use</div>
						<p class="lead my-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>
						<a class="btn btn-secondary btn-sm px-4 py-2 mb-4" href="#">LEARN MORE</a>
					</div>
					<div class="col-12 col-lg-6">
						<img src="/wp-content/themes/developry-lite/assets/dist/img/content-39.jpg" alt="" class="img-fluid w-100" />
					</div>
				</div>
			</div>
		</div>
		<div class="cta">
			<div class="p-5 my-5 bg-secondary rounded-3">
				<div class="container-fluid py-5">
					<div class="display-5 fw-bold">Lets work together<br /> on your next project</div>
					<p class="col-lg-8 fs-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>
					<a class="btn btn-primary btn-sm px-4 py-2" href="#">LEARN MORE</a>
				</div>
			</div>
		</div>
		<br />
		<div class="testimonials">
			<div class="row mt-5">
				<div class="col-lg-4 text-center">
					<img src="/wp-content/themes/developry-lite/assets/dist/img/content-64.jpg" class="rounded-circle" />
					<h4>Anna H.</h4>
					<p>"...Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis…"</p>
				</div>
				<div class="col-lg-4 text-center">
					<img src="/wp-content/themes/developry-lite/assets/dist/img/content-66.jpg" class="rounded-circle"  />
					<h4>Jeff G.</h4>
					<p>"...Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis…"</p>
				</div>
				<div class="col-lg-4 text-center">
					<img src="/wp-content/themes/developry-lite/assets/dist/img/content-65.jpg" class="rounded-circle"  />
					<h4>Loren A.</h4>
					<p>"...Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis…"</p>
				</div>
			</div>
		</div>
	';

	$starter_content = array(
		'widgets'     => array(
			'sidebar-1' => array(
				'search',
				'text_about',
				'meta',
			),
			'footer-1'  => array(
				'calendar',
			),
			'footer-2'  => array(
				'archives',
				'categories',
			),
			'footer-3'  => array(
				'recent-posts',
				'recent-comments',
			),
		),
		'posts'       => array(
			'home'     => array(
				'menu_order'   => 1,
				'post_name'    => 'home',
				'post_title'   => 'Build your custom and<br /> unique website today',
				'post_content' => $lorem_ipsum,
				'post_excerpt' => '
					<p class="lead py-3">Quickly and easily build your website with Developry Lite.</p>
					<p class="d-flex justify-content-center">
						<a href="#" class="btn btn-primary btn-lg px-4 py-3">HOW IT WORKS</a>&nbsp;&nbsp;
						<a href="#" class="btn btn-light btn-lg px-4 py-3">CONTACT US</a>
					</p>
				',
				'thumbnail'    => '',
				'template'     => 'templates/full-width.php',
			),
			'about'    => array(
				'menu_order'   => 2,
				'post_name'    => 'about',
				'post_title'   => esc_html__( 'About', 'developry-lite' ),
				'post_content' => 'The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn\'t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then...',
				'thumbnail'    => '',
			),
			'blog'     => array(
				'menu_order'   => 3,
				'post_name'    => 'blog',
				'post_title'   => esc_html__( 'Blog', 'developry-lite' ),
				'post_content' => 'A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.',
				'thumbnail'    => '',
			),
			'contact'  => array(
				'menu_order'   => 4,
				'post_name'    => 'contact',
				'post_title'   => esc_html__( 'Contact', 'developry-lite' ),
				'post_content' => 'Two driven jocks help fax my big quiz. Quick, Baz, get my woven flax jodhpurs! "Now fax quiz Jack! " my brave ghost pled. Five quacking zephyrs jolt my wax bed. Flummoxed by job, kvetching W. zaps Iraq. Cozy sphinx waves quart jug of bad milk. [contact-form-7 title="Contact form 1"]',
				'thumbnail'    => '',
			),
			'archives' => array(
				'menu_order'   => 5,
				'post_name'    => 'archives',
				'post_type'    => 'page',
				'post_title'   => esc_html__( 'Archives', 'developry-lite' ),
				'post_content' => 'The quick, brown fox jumps over a lazy dog. DJs flock by when MTV ax quiz prog. Junk MTV quiz graced by fox whelps. Bawds jog, flick quartz, vex nymphs. Waltz, bad nymph, for quick jigs vex! Fox nymphs grab quick-jived waltz.',
				'thumbnail'    => '',
				'template'     => 'templates/archives.php',
			),
		),
		'attachments' => array(
			'image-home' => array(
				'post_name'    => 'page-cover',
				'post_title'   => esc_html__( 'Page Cover', 'developry-lite' ),
				'post_content' => esc_html__( 'Page default cover image.', 'developry-lite' ),
				'post_excerpt' => esc_html__( 'Page default cover image.', 'developry-lite' ),
				'file'         => 'assets/dist/img/page-cover.jpg',
			),
		),
		'options'     => array(
			'show_on_front'  => 'page',
			'page_on_front'  => '{{home}}',
			'page_for_posts' => '{{blog}}',
		),
		'nav_menus'   => array(
			'main-nav'   => array(
				'name'  => esc_html__( 'Main Nav', 'developry-lite' ),
				'items' => array(
					'link_home',
					'page_about'    => array(
						'type'      => 'post_type',
						'object'    => 'page',
						'object_id' => '{{about}}',
					),
					'page_blog'     => array(
						'type'      => 'post_type',
						'object'    => 'page',
						'object_id' => '{{blog}}',
					),
					'page_contact'  => array(
						'type'      => 'post_type',
						'object'    => 'page',
						'object_id' => '{{contact}}',
					),
					'page_archives' => array(
						'type'      => 'post_type',
						'object'    => 'page',
						'object_id' => '{{archives}}',
					),
					'page_404'      => array(
						'type'  => 'custom',
						'title' => '404',
						'url'   => '/page-not-found',
					),
				),
			),
			'social-nav' => array(
				'name'  => esc_html__( 'Social Nav', 'developry-lite' ),
				'items' => array(
					'link_facebook'  => array(
						'title'   => esc_html__( 'Facebook', 'developry-lite' ),
						'url'     => esc_url( 'https://facebook.com' ),
						'classes' => 'icon icon-facebook',
					),
					'link_twitter'   => array(
						'title'   => esc_html__( 'Twitter', 'developry-lite' ),
						'url'     => esc_url( 'https://twitter.com' ),
						'classes' => 'icon icon-twitter',
					),
					'link_youtube'   => array(
						'title'   => esc_html__( 'YouTube', 'developry-lite' ),
						'url'     => esc_url( 'https://youtube.com' ),
						'classes' => 'icon icon-youtube',
					),
					'link_instagram' => array(
						'title'   => esc_html__( 'Instagram', 'developry-lite' ),
						'url'     => esc_url( 'https://instagram.com' ),
						'classes' => 'icon icon-instagram',
					),
					'link_github'    => array(
						'title'   => esc_html__( 'Github', 'developry-lite' ),
						'url'     => esc_url( 'https://github.com/krasenslavov' ),
						'classes' => 'icon icon-github',
					),
					'link_linkedin'  => array(
						'title'   => esc_html__( 'Linkedin', 'developry-lite' ),
						'url'     => esc_url( 'https://linkedin.com' ),
						'classes' => 'icon icon-linkedin',
					),
					'link_pinterest' => array(
						'title'   => esc_html__( 'Pinterest', 'developry-lite' ),
						'url'     => esc_url( 'https://pinterest.com' ),
						'classes' => 'icon icon-pinterest',
					),
					'link_reddit'    => array(
						'title'   => esc_html__( 'Reddit', 'developry-lite' ),
						'url'     => esc_url( 'https://reddit.com' ),
						'classes' => 'icon icon-reddit',
					),
					'link_twitch'    => array(
						'title'   => esc_html__( 'Twitch', 'developry-lite' ),
						'url'     => esc_url( 'https://twitch.com' ),
						'classes' => 'icon icon-twitch',
					),
					'link_email'     => array(
						'title'   => esc_html__( 'Email', 'developry-lite' ),
						'url'     => 'mailto:hello@me.com',
						'classes' => 'icon icon-email',
					),
				),
			),
		),
	);

	$starter_content = apply_filters( 'developry_lite_starter_content', $starter_content );

	add_theme_support( 'starter-content', $starter_content );
}

add_action( 'after_setup_theme', __NAMESPACE__ . '\add_theme_starter_content' );
