<?php
/**
 * Using TGMPA plugin script reccommend to the user some plugins that go with the theme.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'tgmpa' ) ) {
	return;
}

/**
 * Configurate and attach plugins to Appearance > Install Plugins.
 */
function recommend_theme_plugins() {

	$plugins = array(
		array(
			'name'     => 'Contact Form 7',
			'slug'     => 'contact-form-7',
			'required' => false,
		),
		array(
			'name'     => 'Web Fonts Loader',
			'slug'     => 'developry-google-fonts',
			'required' => false,
		),
	);

	$config = array(
		'id'           => 'developry-lite',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'parent_slug'  => 'themes.php',
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,
		'dismissable'  => false,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => '',
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', __NAMESPACE__ . '\recommend_theme_plugins' );
