<?php
/**
 * Custom theme features.
 *
 * All features are included to the WP Customizer area under Theme Options panel.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

define( 'DEVELOPRY_LITE_SITE_URL', 'https://developry.com' );

// Documentation.
require_once get_template_directory() . '/inc/classes/class-documentation-section.php';

// Partials.
require_once get_template_directory() . '/inc/controls/class-refresh-partials.php';

// Main.
require_once get_template_directory() . '/inc/controls/class-bootswatch.php';
require_once get_template_directory() . '/inc/controls/class-header-position.php';
require_once get_template_directory() . '/inc/controls/class-container-width.php';
require_once get_template_directory() . '/inc/controls/class-sidebar.php';
require_once get_template_directory() . '/inc/controls/class-page-cover.php';
require_once get_template_directory() . '/inc/controls/class-page-title.php';
require_once get_template_directory() . '/inc/controls/class-search-form.php';

// Colors static text.
require_once get_template_directory() . '/inc/classes/class-colors-static-text.php';

// Text and background colors.
require_once get_template_directory() . '/inc/controls/class-body-background-color.php';
require_once get_template_directory() . '/inc/controls/class-body-text-color.php';
require_once get_template_directory() . '/inc/controls/class-header-background-color.php';
require_once get_template_directory() . '/inc/controls/class-navbar-background-color.php';
require_once get_template_directory() . '/inc/controls/class-navbar-text-color.php';
require_once get_template_directory() . '/inc/controls/class-content-background-color.php';
require_once get_template_directory() . '/inc/controls/class-sidebar-background-color.php';
require_once get_template_directory() . '/inc/controls/class-footer-background-color.php';

/**
 * Attach WP admin notice with link to the theme documentation page.
 */
function show_rating_notice() {
	$user_id = get_current_user_id();

	if ( ! (bool) get_user_meta( $user_id, 'developry_lite_dismiss_rating_notice' ) ) {
		echo sprintf(
			'<div class="notice notice-success is-dismissible">
				<h3>%s</h3>
				<p>%s</p>
				<p style="padding-bottom: 10px">
					<a href="' . DEVELOPRY_LITE_RATE_URL . '" target="_blank" class="button button-primary">%s</a>
					<a href="' . esc_url( admin_url( 'themes.php' ) ) . '?developry_lite_dismiss_rating_notice"><strong>Dismiss this notice</strong></a>
				</p>
			</div>',
			esc_html__( 'Developry Lite 🚀 ', 'developry-lite' ),
			esc_html__( '✨💪🔌 Could you please kindly help the theme in your turn and give us 5 stars? (Thank you in advance) ', 'developry-lite' ),
			'<strong>' . esc_html__( 'Rate us @ WordPress.org', 'developry-lite' ) . '</strong>'
		);
	}
}

add_action( 'admin_notices', __NAMESPACE__ . '\show_rating_notice' );

/**
 * Attach WP admin notice with link to the theme documentation page.
 */
function show_help_notice() {
	$user_id = get_current_user_id();

	if ( ! (bool) get_user_meta( $user_id, 'developry_lite_dismiss_help_notice' ) ) {
		echo sprintf(
			'<div class="notice notice-info is-dismissible">
				<h3>%s</h3>
				<p>%s</p>
				<p style="padding-bottom: 10px">
					<a href="' . DEVELOPRY_LITE_DOCS_URL . '" target="_blank" class="button button-primary">%s</a>
					<a href="' . DEVELOPRY_LITE_SUPPORT_URL . '" target="_blank" class="button">%s</a>
					<a href="' . esc_url( admin_url( 'themes.php' ) ) . '?developry_lite_dismiss_help_notice"><strong>Dismiss this notice</strong></a>
				</p>
			</div>',
			esc_html__( 'Thank you for choosing Developry! ', 'developry-lite' ),
			esc_html__( 'For additonal information, usage, features and demos check out the theme page or support forum. ', 'developry-lite' ),
			'<strong>' . esc_html__( 'Documentation', 'developry-lite' ) . '</strong>',
			'<strong>' . esc_html__( 'Support', 'developry-lite' ) . '</strong>'
		);
	}
}

add_action( 'admin_notices', __NAMESPACE__ . '\show_help_notice' );

/**
 * Allow the user to able to dismiss the notice panel.
 */
function dismiss_admin_notice() {
	$user_id = get_current_user_id();

	if ( isset( $_REQUEST['developry_lite_dismiss_rating_notice'] ) ) {
		add_user_meta( $user_id, 'developry_lite_dismiss_rating_notice', true, true );
	}

	if ( isset( $_REQUEST['developry_lite_dismiss_help_notice'] ) ) {
		add_user_meta( $user_id, 'developry_lite_dismiss_help_notice', true, true );
	}
}

add_action( 'admin_init', __NAMESPACE__ . '\dismiss_admin_notice' );

/**
 * Attach/configure the main Theme Option panel in WP Customizer.
 */
function add_theme_options_section( $wp_customize ) {
	$wp_customize->add_section(
		'developry_lite_theme_options',
		array(
			'priority'           => 181,
			'title'              => esc_html__( 'Theme Options', 'developry-lite' ),
			'description'        => sprintf(
				'<strong>%s</strong><br />%s',
				esc_html__( 'Customize your Developry Lite theme', 'developry-lite' ),
				esc_html__( 'By changing the default options below you will see the results in the preview window.', 'developry-lite' )
			),
			'description_hidden' => true,
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_theme_options_section' );

/**
 * Attach WP Customizer live preview JS script.
 */
function enqueue_customizer_preview_script() {
	wp_enqueue_script(
		'developry-lite-customizer-preview',
		DEVELOPRY_LITE_THEME_URI . '/assets/dist/js/customizer-preview.min.js',
		array( 'jquery', 'customize-preview' ),
		null,
		true
	);

	wp_localize_script(
		'developry-lite-customizer-preview',
		'devrylite',
		array(
			'theme_directory' => esc_url( get_theme_file_uri() ),
		)
	);
}

add_action( 'customize_preview_init', __NAMESPACE__ . '\enqueue_customizer_preview_script' );

/**
 * Add Customizer Theme Options direct linkfrom Appearance.
 */
function direct_theme_options_link() {
	add_theme_page(
		'Theme Options',
		'Theme Options',
		'manage_options',
		esc_url( admin_url( '/customize.php?autofocus[section]=developry_lite_theme_options' ) ),
		''
	);
}

add_action( 'admin_menu', __NAMESPACE__ . '\direct_theme_options_link' );
