<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Display itle and descrition for the archive template.
 */
function display_archive_title_and_description() {
	?>
	<h1 id="content-title" class="content-title">
		<?php echo get_the_archive_title(); ?>
	</h1>
	<?php $description = term_description(); ?>
	<?php if ( ! empty( $description ) ) : ?>
		<p class="lead">
			<?php echo esc_html( $description ); ?>
		</p>
	<?php endif; ?>
	<?php
}

/**
 * Display content header for all the templates.
 */
function display_content_header( $title = '', $additional_classes = '', $subtitle = '' ) {
	?>
	<header id="content-header" class="content-header <?php echo esc_attr( $additional_classes ); ?>">
		<h1 id="content-title" class="content-title">
			<?php echo esc_html( $title ); ?>
			<?php if ( ! empty( $subtitle ) ) : ?>
				<small><?php echo $subtitle; ?></small>
			<?php endif; ?>
		</h1>
	</header>
	<?php
}
