<?php
/**
 * Load stylesheets for our theme's front-end.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'wp_enqueue_style' ) ) {
	return;
}

/**
 * Equeue theme stylesheets.
 */
function enqueue_theme_styles() {
	$theme_version = wp_get_theme()->get( 'Version' );

	// Check if Dashicons are already enqueued.
	if ( ! wp_script_is( 'dashicons', 'enqueued' ) ) {
		wp_enqueue_style( 'dashicons' );
	}

	// Enqueue the theme main style.css file.
	wp_enqueue_style(
		'developry-lite',
		get_stylesheet_uri(),
		array(),
		$theme_version
	);

	// Enqueue the theme Bootswatch (Bootstrap style variations) CSS file(s). Based on WP Customzier selection by user.
	$theme_options = (array) json_decode( DEVELOPRY_LITE_THEME_OPTIONS );

	if ( ! empty( $theme_options['bootswatch_theme'] ) ) {
		wp_enqueue_style(
			'developry-lite-bootswatch',
			DEVELOPRY_LITE_THEME_URI . '/assets/dist/css/themes/' . $theme_options['bootswatch_theme'] . '.min.css',
			array(),
			$theme_version
		);
	} else {
		// Enqueue the default library CSS file in case the option is empty.
		wp_enqueue_style(
			'developry-lite-bootswatch',
			DEVELOPRY_LITE_THEME_URI . '/assets/dist/css/themes/zephyr.min.css',
			array(),
			$theme_version
		);
	}
}

add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\enqueue_theme_styles' );
