<?php
/**
 * Load JS libraries for our theme's front-end.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'wp_register_script' ) || ! function_exists( 'wp_enqueue_script' ) ) {
	return;
}

/**
 * Equeue theme JS scripts.
 */
function enqueue_theme_scripts() {
	$theme_version = wp_get_theme()->get( 'Version' );

	// Register and enqueue the Bootstrap library file from CDN.
	wp_enqueue_script(
		'developry-lite-bootstrap',
		DEVELOPRY_LITE_THEME_URI . '/assets/dist/js/bootstrap.min.js',
		array( 'jquery' ),
		$theme_version,
		true
	);

	// Register and enqueue the Bootstrap classes and styling added via jQuery.
	wp_enqueue_script(
		'developry-lite',
		DEVELOPRY_LITE_THEME_URI . '/assets/dist/js/developry-lite.min.js',
		array( 'jquery', 'developry-lite-bootstrap' ),
		$theme_version,
		true
	);

	// Load comment reply custom JS scripts.
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\enqueue_theme_scripts' );
